<?php

namespace App\Exports;

use App\Models\C2WeofBeneficiary;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class C2WeofBeneficiariesExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    public function collection()
    {
        return C2WeofBeneficiary::with('group')->get();
    }

    public function headings(): array
    {
        return [
            'WEOF ID', 'Name', 'Age', 'County', 'Payam', 'Business Name', 'Category',
            'Registered', 'Monthly Revenue', 'Accelerator', 'Graduated', 'Grant 1st', 'Grant 2nd',
            'Employees Now (F)', 'Employees Now (M)', 'VSLA Group'
        ];
    }

    public function map($b): array
    {
        return [
            $b->woef_id,
            $b->name,
            $b->age,
            $b->county,
            $b->payam,
            $b->business_name,
            $b->business_category,
            $b->registration_status ? 'Yes' : 'No',
            number_format($b->monthly_revenue ?? 0),
            $b->accelerator_participation ? 'Yes' : 'No',
            $b->accelerator_graduation ? 'Yes' : 'No',
            $b->grant_1st_tranche ?? '',
            $b->grant_2nd_tranche ?? '',
            $b->employees_now_female ?? 0,
            $b->employees_now_male ?? 0,
            $b->group?->name ?? '—'
        ];
    }
}