<?php

namespace App\Exports;

use App\Models\Component3\HotlineRegister;
use App\Models\Component3\CallLog;
use App\Models\Component3\PreventionRegister;
use App\Models\Component3\ReferralRegister;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class Component3FullExport implements WithMultipleSheets
{
    public function sheets(): array
    {
        return [
            'Hotline Register'     => new class implements FromCollection, WithHeadings {
                public function collection() { return HotlineRegister::select('incident_id','survivor_code','date_of_report','gbv_type','consent_given_for_information_sharing')->get(); }
                public function headings(): array { return ['Incident ID','Survivor Code','Date','GBV Type','Consent']; }
            },
            'Call Logs'            => new class implements FromCollection, WithHeadings {
                public function collection() { return CallLog::all(); }
                public function headings(): array { return ['Date','Caller ID','Gender','Incident Type','Satisfaction','Attendant']; }
            },
            'Prevention Sessions'  => new class implements FromCollection, WithHeadings {
                public function collection() { return PreventionRegister::select('session_date','state','county','category_of_participants','gender')->get(); }
                public function headings(): array { return ['Date','State','County','Participant Type','Gender']; }
            },
            'Referrals'            => new class implements FromCollection, WithHeadings {
                public function collection() { return ReferralRegister::select('incident_id','survivor_code','date_of_report','referred_from','consent_info_sharing')->get(); }
                public function headings(): array { return ['Incident ID','Survivor','Date','Referred From','Consent']; }
            },
        ];
    }
}