<?php

namespace App\Models\Component4;

use Illuminate\Database\Eloquent\Model;

class C4Participant extends Model
{
    protected $table = 'c4_participants';

    protected $fillable = [
        'serial_no', 'name', 'organization', 'designation', 'gender',
        'state_province', 'start_date', 'completion_date',
        'trained_project_management', 'trained_grm', 'trained_monitoring_evaluation',
        'trained_gbv_programming', 'trained_gender_equality',
        'trained_resource_mobilization', 'trained_leadership_management',
        'comment'
    ];

    protected $casts = [
        'start_date' => 'date',
        'completion_date' => 'date',
    ];

    // Polymorphic supports (future use)
    public function supports()
    {
        return $this->morphMany(C4Support::class, 'supportable');
    }
}