@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', 'Individual Members')

@section('content')
<div class="container-fluid py-4">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Component 1 Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Individual Members</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        <a href="{{ route('component1.members.create') }}" class="btn btn-success">
                            Add New Member
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" class="mb-4">
        <div class="row g-3">
            <div class="col-md-4">
                <select name="group_id" class="form-select">
                    <option value="">All Groups</option>
                    @foreach($groups as $id => $name)
                        <option value="{{ $id }}" {{ request('group_id') == $id ? 'selected' : '' }}>
                            {{ $name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <input type="text" name="search" class="form-control" placeholder="Search name..." value="{{ request('search') }}">
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-outline-success">Filter</button>
                <a href="{{ route('component1.members.index') }}" class="btn btn-outline-secondary">Clear</a>
            </div>
        </div>
    </form>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Serial</th>
                            <th>Name</th>
                            <th>Group</th>
                            <th>Gender</th>
                            <th>Age</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($members as $member)
                            <tr>
                                <td>{{ $member->serial_no }}</td>
                                <td>{{ $member->name }}</td>
                                <td>{{ $member->group->name }}</td>
                                <td>
                                    <span class="badge bg-{{ $member->gender == 'female' ? 'pink' : 'info' }}">
                                        {{ ucfirst($member->gender) }}
                                    </span>
                                </td>
                                <td>{{ $member->age }}</td>
                                <td>
                                    <span class="badge bg-{{ $member->active ? 'success' : 'secondary' }}">
                                        {{ $member->active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('component1.members.show', $member) }}" class="btn btn-sm btn-outline-primary">View</a>
                                    <a href="{{ route('component1.members.edit', $member) }}" class="btn btn-sm btn-outline-secondary">Edit</a>
                                    <form action="{{ route('component1.members.destroy', $member) }}" method="POST" class="d-inline">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-4 text-muted">No members found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="mt-4">
        {{ $members->appends(request()->query())->links() }}
    </div>
</div>
@endsection