@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
@endphp

@extends($layout)

@section('title', 'GrowthLab Businesses')

@section('content')
<div class="container-fluid py-4">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        GrowthLab Businesses Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('component2.dashboard') }}">Component 2 Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('component2.growthlab.index') }}">GrowthLab Businesses</a></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fas fa-building"></i> GrowthLab Businesses
                    </h4>
                    <a href="{{ route('component2.growthlab.create') }}" class="btn btn-light btn-sm">
                        <i class="fas fa-plus"></i> Register New Business
                    </a>
                </div>

                <div class="card-body">
                    <!-- Filters Row -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-3">
                            <input type="text" id="search" class="form-control" placeholder="Search business name, contact, county...">
                        </div>
                        <div class="col-md-2">
                            <select id="sectorFilter" class="form-select">
                                <option value="">All Sectors</option>
                                @foreach(['Agriculture','Education','Healthcare','Real Estate','Services','Supply & Trading','Hospitality','Construction'] as $sector)
                                    <option value="{{ $sector }}">{{ $sector }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="genderFilter" class="form-select">
                                <option value="">All Genders</option>
                                <option value="Female">Female</option>
                                <option value="Male">Male</option>
                                <option value="Adol.Girl">Adolescent Girl</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="verificationFilter" class="form-select">
                                <option value="">Verification Status</option>
                                <option value="Yes">Verified</option>
                                <option value="No">Not Verified</option>
                            </select>
                        </div>
                        <div class="col-md-3 text-end">
                            <button id="resetFilters" class="btn btn-outline-secondary">
                                <i class="fas fa-sync"></i> Reset Filters
                            </button>
                        </div>
                    </div>

                    <!-- Quick Stats Cards -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card text-white bg-primary">
                                <div class="card-body text-center">
                                    <h5>{{ $totalBusinesses }}</h5>
                                    <p class="mb-0">Total Businesses</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-success">
                                <div class="card-body text-center">
                                    <h5>{{ $femaleOwned }}</h5>
                                    <p class="mb-0">Female-Owned</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-info">
                                <div class="card-body text-center">
                                    <h5>{{ $withGrant }}</h5>
                                    <p class="mb-0">Received Grant</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-warning">
                                <div class="card-body text-center">
                                    <h5>SSP {{ number_format($totalDisbursed, 0) }}</h5>
                                    <p class="mb-0">Total Disbursed</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- DataTable -->
                    <div class="table-responsive">
                        <table class="table table-hover align-middle" id="growthlabTable">
                            <thead class="table-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Business Name</th>
                                    <th>Sector</th>
                                    <th>Owner</th>
                                    <th>Gender</th>
                                    <th>County</th>
                                    <th>Grant Status</th>
                                    <th>Verification</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($businesses as $business)
                                <tr>
                                    <td>{{ $business->sn }}</td>
                                    <td>
                                        <strong>{{ $business->business_name }}</strong><br>
                                        @if($business->grant)
                                            <br><small class="text-success">Grant: SSP {{ number_format($business->grant->total_received ?? 0) }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-primary">{{ $business->business_sector }}</span>
                                    </td>
                                    <td>{{ $business->contact_person_name ?? '-' }}</td>
                                    <td>
                                        @if($business->owner_gender === 'Female')
                                            <i class="fas fa-female text-pink"></i>
                                        @elseif($business->owner_gender === 'Adol.Girl')
                                            <i class="fas fa-child text-purple"></i>
                                        @else
                                            <i class="fas fa-male text-blue"></i>
                                        @endif
                                        {{ $business->owner_gender }}
                                    </td>
                                    <td>{{ $business->county ?? '-' }}</td>
                                    <td>
                                        @if($business->grant)
                                            @if($business->grant->total_received > 0)
                                                <span class="badge bg-success">Disbursed</span>
                                            @else
                                                <span class="badge bg-warning">Approved</span>
                                            @endif
                                        @else
                                            <span class="badge bg-secondary">No Grant</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge {{ $business->physical_verification === 'Yes' ? 'bg-success' : 'bg-danger' }}">
                                            {{ $business->physical_verification === 'Yes' ? 'Verified' : 'Pending' }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <a href="{{ route('component2.growthlab.edit', $business) }}" class="btn btn-sm btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('component2.growthlab.destroy', $business) }}" method="POST" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this business?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="mt-3">
                        {{ $businesses->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- DataTables + jQuery Script -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.min.js"></script>
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.bootstrap5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/2.0.8/css/dataTables.bootstrap5.min.css">

<script>
$(document).ready(function() {
    const table = $('#growthlabTable').DataTable({
        pageLength: 25,
        responsive: true,
        order: [[0, 'asc']],
        columnDefs: [
            { orderable: false, targets: 8 } // disable sorting on Actions column
        ]
    });

    // Live Search
    $('#search').on('keyup', function() {
        table.search(this.value).draw();
    });

    // Filters
    $('#sectorFilter, #genderFilter, #verificationFilter').on('change', function() {
        const sector = $('#sectorFilter').val();
        const gender = $('#genderFilter').val();
        const verification = $('#verificationFilter').val();

        table.column(2).search(sector);           // Sector column
        table.column(4).search(gender);           // Gender column
        table.column(7).search(verification);     // Verification column

        table.draw();
    });

    // Reset button
    $('#resetFilters').on('click', function() {
        $('#search, #sectorFilter, #genderFilter, #verificationFilter').val('');
        table.search('').columns().search('').draw();
    });
});
</script>
@endsection