@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', 'WEOF Beneficiaries')

@section('content')
<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="text-success">WEOF Beneficiaries</h3>
        <a href="{{ route('component1.weof.create') }}" class="btn btn-success">
            Add WEOF Beneficiary
        </a>
    </div>

    <!-- Filters -->
    <form method="GET" class="mb-4">
        <div class="row g-3">
            <div class="col-md-4">
                <select name="group_id" class="form-select">
                    <option value="">All Groups</option>
                    @foreach($groups as $id => $name)
                        <option value="{{ $id }}" {{ request('group_id') == $id ? 'selected' : '' }}>
                            {{ $name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <input type="text" name="search" class="form-control" placeholder="Search name or business..." value="{{ request('search') }}">
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-outline-success">Filter</button>
                <a href="{{ route('component1.weof.index') }}" class="btn btn-outline-secondary">Clear</a>
            </div>
        </div>
    </form>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>WEOF ID</th>
                            <th>Name</th>
                            <th>Business</th>
                            <th>County</th>
                            <th>Participation</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($beneficiaries as $weof)
                            <tr>
                                <td><strong>{{ $weof->woef_id }}</strong></td>
                                <td>{{ $weof->name }}</td>
                                <td>{{ $weof->business_name }}</td>
                                <td>{{ $weof->county }}</td>
                                <td>
                                    <span class="badge bg-success">{{ $weof->participation_label }}</span>
                                </td>
                                <td>
                                    <a href="{{ route('component1.weof.show', $weof) }}" class="btn btn-sm btn-outline-primary">View</a>
                                    <a href="{{ route('component1.weof.edit', $weof) }}" class="btn btn-sm btn-outline-secondary">Edit</a>
                                    <form action="{{ route('component1.weof.destroy', $weof) }}" method="POST" class="d-inline">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">No beneficiaries found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="mt-4">
        {{ $beneficiaries->appends(request()->query())->links() }}
    </div>
</div>
@endsection