@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
@endphp

@extends($layout)

@section('title', 'SeedLab Beneficiaries')

@section('content')
<div class="container-fluid py-4">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        SeedLab Beneficiaries Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('component2.dashboard') }}">Component 2 Dashboard</a></li>
                            <li class="breadcrumb-item active">SeedLab Beneficiaries</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fas fa-seedling"></i> SeedLab Beneficiaries
                    </h4>
                    <a href="{{ route('component2.seedlab.create') }}" class="btn btn-light btn-sm">
                        <i class="fas fa-plus"></i> Register New Beneficiary
                    </a>
                </div>

                <div class="card-body">
                    <!-- Filters -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-3">
                            <input type="text" id="search" class="form-control" placeholder="Search name, business, county...">
                        </div>
                        <div class="col-md-2">
                            <select id="sectorFilter" class="form-select">
                                <option value="">All Sectors</option>
                                @foreach(['Agriculture','Education','Healthcare','Real Estate','Services','Supply & Trading','Hospitality','Construction'] as $sector)
                                    <option value="{{ $sector }}">{{ $sector }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="cohortFilter" class="form-select">
                                <option value="">All Cohorts</option>
                                <option value="Cohort 1/25">Cohort 1/25</option>
                                <option value="Cohort 2/25">Cohort 2/25</option>
                                <option value="Cohort 1/26">Cohort 1/26</option>
                                <option value="Cohort 2/26">Cohort 2/26</option>
                                <option value="Cohort 3/26">Cohort 3/26</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="genderFilter" class="form-select">
                                <option value="">All Genders</option>
                                <option value="Female">Female</option>
                                <option value="Male">Male</option>
                                <option value="Adol.Girl">Adolescent Girl</option>
                            </select>
                        </div>
                        <div class="col-md-3 text-end">
                            <button id="resetFilters" class="btn btn-outline-secondary">
                                <i class="fas fa-sync"></i> Reset Filters
                            </button>
                        </div>
                    </div>

                    <!-- Quick Stats -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card text-white bg-primary">
                                <div class="card-body text-center">
                                    <h5>{{ $totalBeneficiaries }}</h5>
                                    <p class="mb-0">Total Registered</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-pink">
                                <div class="card-body text-center">
                                    <h5>{{ $femaleCount }}</h5>
                                    <p class="mb-0">Women & Girls</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-info">
                                <div class="card-body text-center">
                                    <h5>{{ $withGrant }}</h5>
                                    <p class="mb-0">Received Grant</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-success">
                                <div class="card-body text-center">
                                    <h5>SSP {{ number_format($totalDisbursed, 0) }}</h5>
                                    <p class="mb-0">Total Disbursed</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- DataTable -->
                    <div class="table-responsive">
                        <table class="table table-hover align-middle" id="seedlabTable">
                            <thead class="table-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Beneficiary</th>
                                    <th>Sector</th>
                                    <th>Cohort</th>
                                    <th>Gender</th>
                                    <th>County</th>
                                    <th>Modules Completed</th>
                                    <th>Grant</th>
                                    <th>Verification</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($beneficiaries as $b)
                                <tr>
                                    <td><strong>{{ $b->sn }}</strong></td>
                                    <td>
                                        <div><strong>{{ $b->full_name }}</strong></div>
                                        <small class="text-muted">{{ $b->business_type ?? 'Individual' }}</small>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary">{{ $b->business_sector }}</span>
                                    </td>
                                    <td><span class="badge bg-secondary">{{ $b->cohort_year }}</span></td>
                                    <td>
                                        @if($b->gender === 'Female')
                                            <i class="fas fa-female text-pink"></i>
                                        @elseif($b->gender === 'Adol.Girl')
                                            <i class="fas fa-child text-purple"></i>
                                        @else
                                            <i class="fas fa-male text-blue"></i>
                                        @endif
                                        {{ $b->gender }}
                                    </td>
                                    <td>{{ $b->county ?? '-' }}</td>
                                    <td>
                                        @php
                                            $completed = collect(['1','2','3','4','5','6','7','8'])
                                                ->filter(fn($m) => $b["module_$m"] === 'Completed')
                                                ->count();
                                        @endphp
                                        <span class="badge bg-{{ $completed >= 8 ? 'success' : ($completed >= 4 ? 'warning' : 'secondary') }}">
                                            {{ $completed }}/8
                                        </span>
                                    </td>
                                    <td>
                                        @if($b->grant)
                                            @if($b->grant->total_received > 0)
                                                <span class="badge bg-success">SSP {{ number_format($b->grant->total_received) }}</span>
                                            @else
                                                <span class="badge bg-warning">Approved</span>
                                            @endif
                                        @else
                                            <span class="badge bg-light text-dark">No Grant</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge {{ $b->physical_verification === 'Yes' ? 'bg-success' : 'bg-danger' }}">
                                            {{ $b->physical_verification === 'Yes' ? 'Verified' : 'Pending' }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <a href="{{ route('component2.seedlab.edit', $b) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('component2.seedlab.destroy', $b) }}" method="POST" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger"
                                                    onclick="return confirm('Delete this beneficiary?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="mt-3">
                        {{ $beneficiaries->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- DataTables Script -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.min.js"></script>
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.bootstrap5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/2.0.8/css/dataTables.bootstrap5.min.css">

<script>
$(document).ready(function() {
    const table = $('#seedlabTable').DataTable({
        pageLength: 25,
        responsive: true,
        order: [[0, 'asc']],
        columnDefs: [{ orderable: false, targets: 9 }]
    });

    $('#search').on('keyup', function() {
        table.search(this.value).draw();
    });

    $('#sectorFilter, #cohortFilter, #genderFilter').on('change', function() {
        table.column(2).search($('#sectorFilter').val());
        table.column(3).search($('#cohortFilter').val());
        table.column(4).search($('#genderFilter').val());
        table.draw();
    });

    $('#resetFilters').on('click', function() {
        $('#search, #sectorFilter, #cohortFilter, #genderFilter').val('');
        table.search('').columns().search('').draw();
    });
});
</script>
@endsection