@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
@endphp

@extends($layout)

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>GBV Hotline Register</h2>
    <a href="{{ route('component3.hotline.create') }}" class="btn btn-sswseep text-white">
        <i class="fas fa-plus"></i> Register New Incident
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-success">
                    <tr>
                        <th>Incident ID</th>
                        <th>Survivor Code</th>
                        <th>Date of Report</th>
                        <th>GBV Type</th>
                        <th>Consent</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($registers as $r)
                    <tr>
                        <td><strong>{{ $r->incident_id }}</strong></td>
                        <td>{{ $r->survivor_code }}</td>
                        <td>{{ $r->date_of_report->format('d/m/Y') }}</td>
                        <td>{{ $r->gbv_type }}</td>
                        <td>{{ $r->consent_given_for_information_sharing ? 'Yes' : 'No' }}</td>
                        <td>
                            <a href="{{ route('component3.hotline.show', $r) }}" class="btn btn-sm btn-outline-primary">View</a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        {{ $registers->links() }}
    </div>
</div>
@endsection