<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
?>



<?php $__env->startSection('title', 'Add New Member'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4 py-3">
    <!-- Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Add New Member
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('component1.dashboard')); ?>">Component 1 Dashboard</a></li>
                            <li class="breadcrumb-item active">Members</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <h3 class="text-success mb-4 text-center fw-bold">
                Register New Group Member
                <?php if($selectedGroup): ?>
                    <small class="text-muted d-block mt-1">to: <?php echo e(\App\Models\C1Group::find($selectedGroup)->name); ?></small>
                <?php endif; ?>
            </h3>

            <div class="card border-secondary border-2 shadow-lg rounded-3">
                <div class="card-body p-4 p-md-5">
                    <form action="<?php echo e(route('component1.members.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="group_id" value="<?php echo e(old('group_id', $selectedGroup)); ?>">

                        <h5 class="mb-3 text-primary border-bottom border-secondary pb-2"><i class="fas fa-id-card-alt me-2"></i> Membership Details</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Group <span class="text-danger">*</span></label>
                                <select style="border: 1px solid #444;" name="group_id" class="form-select <?php $__errorArgs = ['group_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required <?php if($selectedGroup): ?> disabled <?php endif; ?>>
                                    <option value="">-- Select Group --</option>
                                    <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>" <?php echo e(old('group_id', $selectedGroup) == $id ? 'selected' : ''); ?>>
                                            <?php echo e($name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['group_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold">Serial No. <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="number" name="serial_no" class="form-control <?php $__errorArgs = ['serial_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('serial_no')); ?>" min="1" required>
                                <?php $__errorArgs = ['serial_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold">Snapshot Month <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="month" name="month" class="form-control <?php $__errorArgs = ['month'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('month')); ?>" required>
                                <?php $__errorArgs = ['month'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>


                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-user me-2"></i> Personal Details</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Full Name <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="text" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('name')); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold">Gender <span class="text-danger">*</span></label>
                                <select style="border: 1px solid #444;" name="gender" class="form-select <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="">-- Select --</option>
                                    <option value="female" <?php echo e(old('gender') == 'female' ? 'selected' : ''); ?>>Female</option>
                                    <option value="male" <?php echo e(old('gender') == 'male' ? 'selected' : ''); ?>>Male</option>
                                </select>
                                <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold">Age <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="number" name="age" class="form-control <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('age')); ?>" min="10" max="100" required>
                                <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold">Marital Status</label>
                                <select style="border: 1px solid #444;" name="marital_status" class="form-select">
                                    <option value="">-- Select --</option>
                                    <option value="married" <?php echo e(old('marital_status') == 'married' ? 'selected' : ''); ?>>Married</option>
                                    <option value="not_married" <?php echo e(old('marital_status') == 'not_married' ? 'selected' : ''); ?>>Not Married</option>
                                    <option value="divorced" <?php echo e(old('marital_status') == 'divorced' ? 'selected' : ''); ?>>Divorced</option>
                                    <option value="widowed" <?php echo e(old('marital_status') == 'widowed' ? 'selected' : ''); ?>>Widowed</option>
                                </select>
                            </div>
                            <div class="col-md-3 d-flex align-items-center">
                                <div class="form-check">
                                    <input style="border: 1px solid #444;" class="form-check-input" type="checkbox" name="exec_committee" value="1" id="exec_committee" <?php echo e(old('exec_committee') ? 'checked' : ''); ?>>
                                    <label class="form-check-label fw-bold" for="exec_committee">Executive Committee</label>
                                </div>
                            </div>
                            <div class="col-md-3 d-flex align-items-center">
                                <div class="form-check">
                                    <input style="border: 1px solid #444;" class="form-check-input" type="checkbox" name="disability_status" value="1" id="disability_status" <?php echo e(old('disability_status') ? 'checked' : ''); ?>>
                                    <label class="form-check-label fw-bold" for="disability_status">Has Disability</label>
                                </div>
                            </div>
                            <div class="col-md-3 d-flex align-items-center">
                                <div class="form-check">
                                    <input style="border: 1px solid #444;" class="form-check-input" type="checkbox" name="head_household" value="1" id="head_household" <?php echo e(old('head_household') ? 'checked' : ''); ?>>
                                    <label class="form-check-label fw-bold" for="head_household">Head of Household</label>
                                </div>
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-home me-2"></i> Household Composition</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Total Members</label>
                                <input type="number" name="num_hh_members_total" class="form-control"
                                       value="<?php echo e(old('num_hh_members_total')); ?>" min="0">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Female Adult</label>
                                <input type="number" name="num_hh_female_adult" class="form-control"
                                       value="<?php echo e(old('num_hh_female_adult')); ?>" min="0">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Female Adol (14–24)</label>
                                <input type="number" name="num_hh_female_adol" class="form-control"
                                       value="<?php echo e(old('num_hh_female_adol')); ?>" min="0">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Male Adult</label>
                                <input type="number" name="num_hh_male_adult" class="form-control"
                                       value="<?php echo e(old('num_hh_male_adult')); ?>" min="0">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Male Adol (14–24)</label>
                                <input type="number" name="num_hh_male_adol" class="form-control"
                                       value="<?php echo e(old('num_hh_male_adol')); ?>" min="0">
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-graduation-cap me-2"></i> Training & Support</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-6">
                                <h6 class="text-success fw-bold">Core Trainings Completed:</h6>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="completed_core_1" value="1" id="core1" <?php echo e(old('completed_core_1') ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="core1">Functional Literacy</label>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="completed_core_3" value="1" id="core3" <?php echo e(old('completed_core_3') ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="core3">Business Dev</label>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="completed_core_2" value="1" id="core2" <?php echo e(old('completed_core_2') ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="core2">VSLA Operations</label>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="completed_core_4" value="1" id="core4" <?php echo e(old('completed_core_4') ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="core4">Digital Literacy</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Specialized Training</label>
                                <div class="form-check mb-1">
                                    <input class="form-check-input" type="checkbox" name="received_specialized_1" value="1" id="specialized" <?php echo e(old('received_specialized_1') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="specialized">Received Specialized Training</label>
                                </div>
                                <textarea name="specialized_1_details" class="form-control" rows="2"
                                          placeholder="Details (optional)"><?php echo e(old('specialized_1_details')); ?></textarea>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">In-Kind Support</label>
                                <div class="form-check mb-1">
                                    <input class="form-check-input" type="checkbox" name="received_in_kind" value="1" id="in_kind" <?php echo e(old('received_in_kind') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="in_kind">Received</label>
                                </div>
                                <select name="in_kind_source" class="form-select">
                                    <option value="">-- Source --</option>
                                    <option value="sswseep" <?php echo e(old('in_kind_source') == 'sswseep' ? 'selected' : ''); ?>>SSWSEEP</option>
                                    <option value="others" <?php echo e(old('in_kind_source') == 'others' ? 'selected' : ''); ?>>Others</option>
                                </select>
                            </div>

                            <!-- adding reporting integration -->
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label for="category">VSLA Category</label>
                                    <select name="category" id="category" class="form-control <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="">-- Select --</option>
                                        <option value="mature" <?php echo e(old('category', $member->category ?? '') == 'mature' ? 'selected' : ''); ?>>Mature</option>
                                        <option value="progressive" <?php echo e(old('category', $member->category ?? '') == 'progressive' ? 'selected' : ''); ?>>Progressive</option>
                                        <option value="new" <?php echo e(old('category', $member->category ?? '') == 'new' ? 'selected' : ''); ?>>New</option>
                                    </select>
                                    <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="invalid-feedback"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="existing_income_activities">Existing Main Income Generation Activities</label>
                                    <textarea name="existing_income_activities" id="existing_income_activities" rows="2"
                                            class="form-control <?php $__errorArgs = ['existing_income_activities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="e.g. Farming, Petty trading"><?php echo e(old('existing_income_activities', $member->existing_income_activities ?? '')); ?></textarea>
                                    <?php $__errorArgs = ['existing_income_activities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="invalid-feedback"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mt-4">
                                    <label>Received Certificate?</label><br>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="received_certificate" value="1" 
                                            <?php echo e(old('received_certificate', $member->received_certificate ?? false) ? 'checked' : ''); ?>>
                                        <label class="form-check-label">Yes</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="received_certificate" value="0" 
                                            <?php echo e(old('received_certificate', $member->received_certificate ?? false) ? '' : 'checked'); ?>>
                                        <label class="form-check-label">No</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Productive Equipment</label>
                                <div class="form-check mb-1">
                                    <input class="form-check-input" type="checkbox" name="received_productive_equip" value="1" id="equip" <?php echo e(old('received_productive_equip') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="equip">Received</label>
                                </div>
                                <select name="equip_source" class="form-select">
                                    <option value="">-- Source --</option>
                                    <option value="sswseep" <?php echo e(old('equip_source') == 'sswseep' ? 'selected' : ''); ?>>SSWSEEP</option>
                                    <option value="others" <?php echo e(old('equip_source') == 'others' ? 'selected' : ''); ?>>Others</option>
                                </select>
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-chart-line me-2"></i> Economic & Financial Status</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-3">
                                <div class="form-check mt-2">
                                    <input class="form-check-input" type="checkbox" name="started_new_business" value="1" id="new_business" <?php echo e(old('started_new_business') ? 'checked' : ''); ?>>
                                    <label class="form-check-label fw-bold" for="new_business">Started New Business</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-check mt-2">
                                    <input class="form-check-input" type="checkbox" name="actively_saving_monthly" value="1" id="saving" <?php echo e(old('actively_saving_monthly') ? 'checked' : ''); ?>>
                                    <label class="form-check-label fw-bold" for="saving">Actively Saving</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Total Savings (SSP)</label>
                                <input type="number" step="0.01" name="total_savings" class="form-control"
                                       value="<?php echo e(old('total_savings')); ?>" min="0">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Outstanding Loan (SSP)</label>
                                <input type="number" step="0.01" name="outstanding_loan" class="form-control"
                                       value="<?php echo e(old('outstanding_loan')); ?>" min="0">
                            </div>
                        </div>

                        <div class="mt-4 pt-3 border-top border-secondary text-end">
                            <a href="<?php echo e(route('component1.members.index')); ?>" class="btn btn-outline-secondary me-2"><i class="fas fa-times me-1"></i> Cancel</a>
                            <button type="submit" class="btn btn-success px-4"><i class="fas fa-save me-1"></i> Save Member</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kulzweru/sswseepdatabase.blockchaintech.co.ke/resources/views/component1/members/create.blade.php ENDPATH**/ ?>