

<?php $__env->startSection('title', 'Super Admin Dashboard'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* DHIS2-inspired Color Palette */
    :root {
        --dhis2-blue-primary: #2c6693;
        --dhis2-blue-dark: #276696;
        --dhis2-blue-light: #4a90c2;
        --dhis2-teal: #00796b;
        --dhis2-grey-50: #f4f6f8;
        --dhis2-grey-100: #e8edf2;
        --dhis2-grey-200: #d5dde5;
        --dhis2-grey-300: #a0adb8;
        --dhis2-grey-600: #6c7a89;
        --dhis2-grey-900: #212934;
        --success-green: #4caf50;
        --warning-orange: #ff9800;
        --danger-red: #f44336;
        --info-cyan: #00bcd4;
        --crown-gold: #ffc107;
        --sswseep-green: #14A850
    }

    body {
        background-color: var(--dhis2-grey-50);
        font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
    }

    /* Super Admin Header */
    .super-admin-header {
        background: linear-gradient(135deg, var(--success-green) 0%, var(--sswseep-green) 100%);
        padding: 2rem 0;
        margin-bottom: 2rem;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        border-bottom: 4px solid var(--crown-gold);
    }

    .admin-title {
        color: white;
        font-size: 2rem;
        font-weight: 600;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .crown-icon {
        font-size: 2rem;
        color: var(--crown-gold);
        animation: pulse 2s ease-in-out infinite;
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.1); }
    }

    .admin-subtitle {
        color: rgba(255, 255, 255, 0.9);
        font-size: 1rem;
        margin-top: 0.5rem;
        margin-bottom: 0;
    }

    .admin-subtitle strong {
        color: var(--crown-gold);
        font-weight: 600;
    }

    /* Stats Cards */
    .stat-card {
        background: white;
        border-radius: 8px;
        padding: 1.75rem;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border-left: 4px solid var(--dhis2-blue-primary);
        transition: all 0.3s ease;
        height: 100%;
        position: relative;
        overflow: hidden;
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 120px;
        height: 120px;
        background: radial-gradient(circle, rgba(44, 102, 147, 0.05) 0%, transparent 70%);
        border-radius: 50%;
        transform: translate(30%, -30%);
    }

    .stat-card:hover {
        box-shadow: 0 6px 20px rgba(0,0,0,0.12);
        transform: translateY(-4px);
    }

    .stat-card.primary {
        border-left-color: var(--dhis2-blue-primary);
    }

    .stat-card.success {
        border-left-color: var(--success-green);
    }

    .stat-card.info {
        border-left-color: var(--info-cyan);
    }

    .stat-card.warning {
        border-left-color: var(--warning-orange);
    }

    .stat-label {
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        color: var(--dhis2-grey-600);
        margin-bottom: 0.75rem;
        position: relative;
        z-index: 1;
    }

    .stat-value {
        font-size: 2.25rem;
        font-weight: 600;
        color: var(--dhis2-grey-900);
        line-height: 1;
        position: relative;
        z-index: 1;
    }

    .stat-icon {
        position: absolute;
        right: 1.5rem;
        top: 50%;
        transform: translateY(-50%);
        font-size: 3rem;
        opacity: 0.1;
        z-index: 0;
    }

    /* Component Cards */
    .section-header {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        margin-bottom: 1.5rem;
        padding-bottom: 0.75rem;
        border-bottom: 2px solid var(--dhis2-grey-200);
    }

    .section-header h4 {
        font-size: 1.25rem;
        font-weight: 600;
        color: var(--dhis2-grey-900);
        margin: 0;
    }

    .section-header i {
        color: var(--dhis2-blue-primary);
        font-size: 1.5rem;
    }

    .component-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        transition: all 0.3s ease;
        height: 100%;
        overflow: hidden;
        border: 2px solid transparent;
    }

    .component-card:hover {
        box-shadow: 0 8px 24px rgba(0,0,0,0.15);
        transform: translateY(-6px);
        border-color: var(--dhis2-blue-primary);
    }

    .component-card.active {
        border-color: var(--success-green);
    }

    .component-card.locked {
        background: var(--dhis2-grey-50);
        opacity: 0.7;
    }

    .component-card.locked:hover {
        transform: none;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border-color: transparent;
    }

    .component-body {
        padding: 2.5rem 2rem;
        text-align: center;
    }

    .component-icon {
        font-size: 3.5rem;
        margin-bottom: 1.25rem;
        display: inline-block;
    }

    .component-icon.success {
        color: var(--success-green);
    }

    .component-icon.secondary {
        color: var(--dhis2-grey-400);
    }

    .component-icon.danger {
        color: var(--danger-red);
    }

    .component-icon.info {
        color: var(--info-cyan);
    }

    .component-title {
        font-size: 1.25rem;
        font-weight: 600;
        color: var(--dhis2-grey-900);
        margin-bottom: 0.5rem;
    }

    .component-description {
        font-size: 0.875rem;
        color: var(--dhis2-grey-600);
        margin-bottom: 1.5rem;
    }

    .component-badge {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        border-radius: 12px;
        font-size: 0.75rem;
        font-weight: 600;
        margin-bottom: 1rem;
    }

    .badge-active {
        background: #e8f5e9;
        color: var(--success-green);
    }

    .badge-locked {
        background: var(--dhis2-grey-200);
        color: var(--dhis2-grey-600);
    }

    /* Buttons */
    .btn-component-enter {
        background: var(--success-green);
        color: white;
        border: none;
        padding: 0.75rem 2rem;
        border-radius: 6px;
        font-weight: 600;
        font-size: 0.95rem;
        transition: all 0.2s ease;
        box-shadow: 0 2px 8px rgba(76, 175, 80, 0.3);
    }

    .btn-component-enter:hover {
        background: #43a047;
        color: white;
        transform: scale(1.05);
        box-shadow: 0 4px 16px rgba(76, 175, 80, 0.4);
    }

    .btn-component-locked {
        background: var(--dhis2-grey-300);
        color: white;
        border: none;
        padding: 0.75rem 2rem;
        border-radius: 6px;
        font-weight: 600;
        font-size: 0.95rem;
        cursor: not-allowed;
    }

    /* Quick Actions */
    .quick-actions-card {
        background: white;
        border-radius: 8px;
        padding: 2rem;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        margin-top: 2rem;
    }

    .btn-quick-action {
        background: white;
        color: var(--dhis2-blue-primary);
        border: 2px solid var(--dhis2-blue-primary);
        padding: 0.75rem 1.5rem;
        border-radius: 6px;
        font-weight: 600;
        font-size: 0.95rem;
        transition: all 0.2s ease;
        margin-right: 0.75rem;
        margin-bottom: 0.75rem;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }

    .btn-quick-action:hover {
        background: var(--dhis2-blue-primary);
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(44, 102, 147, 0.3);
    }

    .btn-quick-action.info {
        border-color: var(--info-cyan);
        color: var(--info-cyan);
    }

    .btn-quick-action.info:hover {
        background: var(--info-cyan);
        color: white;
    }

    .btn-quick-action.warning {
        border-color: var(--warning-orange);
        color: var(--warning-orange);
    }

    .btn-quick-action.warning:hover {
        background: var(--warning-orange);
        color: white;
    }

    /* Grid Layout */
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
        gap: 1.5rem;
        margin-bottom: 3rem;
    }

    .components-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.5rem;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .admin-title {
            font-size: 1.5rem;
        }

        .stat-value {
            font-size: 1.75rem;
        }

        .component-body {
            padding: 2rem 1.5rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4 py-3">
    <!-- Super Admin Header -->
    <div class="super-admin-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <h1 class="admin-title">
                        <i class="fas fa-crown crown-icon"></i>
                        Super Admin Dashboard
                    </h1>
                    <p class="admin-subtitle">
                        Welcome, <strong><?php echo e(Auth::user()->name); ?></strong> — You have full access to all SSWSEEP components.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    

    <!-- Component Access Section -->
    <div class="section-header">
        <i class="fas fa-th-large"></i>
        <h4>Access Components Dashboards</h4>
    </div>

    <div class="components-grid">
        <!-- Component 1 - Active -->
        <div class="component-card active">
            <div class="component-body">
                <span class="component-badge badge-active">
                    <i class="fas fa-check-circle"></i> Active
                </span>
                <div class="component-icon success">
                    <!-- <i class="fas fa-handshake"></i> -->
                    <img src="<?php echo e(asset('images/component1-icon.png')); ?>" width="70" alt="">
                </div>
                <h5 class="component-title">Component 1</h5>
                <p class="component-description">VSLA Groups, Members</p>
                <a href="<?php echo e(route('component1.dashboard')); ?>" class="btn btn-component-enter" target="_blank">
                    <i class="fas fa-arrow-right"></i> Enter Component 1
                </a>
            </div>
        </div>

        <!-- Component 2 - Locked -->
        <div class="component-card locked">
            <div class="component-body">
                <span class="component-badge badge-active">
                    <i class="fas fa-check-circle"></i> Active
                </span>
                <div class="component-icon secondary">
                    <img src="<?php echo e(asset('images/component2-icon.png')); ?>" width="70" alt="">
                </div>
                <h5 class="component-title">Component 2</h5>
                <p class="component-description">WEOF Beneficiaries</p>
                <a href="<?php echo e(route('component2.index')); ?>" class="btn btn-component-enter" target="_blank">
                    <i class="fas fa-arrow-right"></i> Enter Component 2 
                </a>
            </div>
        </div>

        <!-- Component 3 - Locked -->
        <div class="component-card locked">
            <div class="component-body">
                <span class="component-badge badge-active">
                    <i class="fas fa-check-circle"></i> Active
                </span>
                <div class="component-icon danger">
                    <img src="<?php echo e(asset('images/component3-icon.png')); ?>" width="70" alt="">
                </div>
                <h5 class="component-title">Component 3</h5>
                <p class="component-description">GBV Prevention & Protection</p>
                <a href="<?php echo e(route('component3.dashboard')); ?>" class="btn btn-component-enter" target="_blank">
                    <i class="fas fa-arrow-right"></i> Enter Component 3
                </a>
            </div>
        </div>

        <!-- Component 4 - Locked -->
        <div class="component-card locked">
            <div class="component-body">
                <span class="component-badge badge-active">
                    <i class="fas fa-check-circle"></i> Active
                </span>
                <div class="component-icon info">
                    <img src="<?php echo e(asset('images/component4-icon.png')); ?>" width="70" alt="">
                </div>
                <h5 class="component-title">Component 4</h5>
                <p class="component-description">M&E and Reporting</p>
                <a href="<?php echo e(route('component4.index')); ?>" class="btn btn-component-enter" target="_blank">
                    <i class="fas fa-arrow-right"></i> Enter Component 4
                </a>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions-card">
        <div class="section-header" style="border: none; padding-bottom: 0; margin-bottom: 1.25rem;">
            <i class="fas fa-bolt"></i>
            <h4>Quick Actions</h4>
        </div>
        <div>
            <a href="<?php echo e(route('admin.users.index') ?? '#'); ?>" class="btn btn-quick-action">
                <i class="fas fa-users-cog"></i>
                <span>Manage Users</span>
            </a>
            <a href="#" class="btn btn-quick-action info">
                <i class="fas fa-download"></i>
                <span>Export Master Data</span>
            </a>
            <a href="#" class="btn btn-quick-action warning">
                <i class="fas fa-shield-alt"></i>
                <span>System Logs</span>
            </a>
            <a href="#" class="btn btn-quick-action">
                <i class="fas fa-cog"></i>
                <span>System Settings</span>
            </a>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Add smooth animations on load
    document.addEventListener('DOMContentLoaded', function() {
        const cards = document.querySelectorAll('.stat-card, .component-card');
        cards.forEach((card, index) => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            setTimeout(() => {
                card.style.transition = 'all 0.5s ease';
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, index * 50);
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kulzweru/sswseepdatabase.blockchaintech.co.ke/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>