<?php

namespace App\Http\Controllers\Component1;

use App\Http\Controllers\Controller;
use App\Models\C1Group;
use App\Models\C1Member;
use App\Models\C1WeofBeneficiary;
use App\Models\C1Support;
use Illuminate\View\View;
use Illuminate\Support\Facades\DB;

class C1DashboardController extends Controller
{
    public function __invoke(): View
    {
        // 1. Registered VSLA/Community Groups
        $totalGroups = C1Group::count();

        // 2. Registered Members (active only)
        $totalMembers = C1Member::active()->count();

        // 3. WEOF Beneficiaries
        //$totalWeof = C1WeofBeneficiary::count();

        // 4. Total Supports (any type)
        $totalSupports = C1Support::count();

        // 5. KPI Quick Stats (example – you can replace with real KPI logic later)
        $kpiStats = [
            'groups'        => $totalGroups,
            'members'       => $totalMembers,
            'supports'      => $totalSupports,
        ];

        // === Core Stats ===
        $stats = [
            'total_groups'      => C1Group::count(),
            'total_members'     => C1Member::sum(DB::raw('num_hh_members_total')) ?: C1Member::count(),
            'active_groups'     => C1Group::whereHas('members', fn($q) => $q->where('active', true))->count(),
        ];

        // === Chart 1: Groups by County ===
        $groupsByCounty = C1Group::select('county', DB::raw('count(*) as total'))
            ->groupBy('county')
            ->orderByDesc('total')
            ->limit(10)
            ->get();

        // === Chart 2: Gender Distribution (Members) ===
        $genderData = [
            'female' => C1Member::where('gender', 'female')->count(),
            'male'   => C1Member::where('gender', 'male')->count(),
        ];

        // === Chart 4: Training Completion Rate (Core 1–4) ===
        $trainingCompletion = [
            'Core 1' => C1Member::where('completed_core_1', true)->count(),
            'Core 2' => C1Member::where('completed_core_2', true)->count(),
            'Core 3' => C1Member::where('completed_core_3', true)->count(),
            'Core 4' => C1Member::where('completed_core_4', true)->count(),
        ];

        // === GBV Vulnerability ===
        $gbvVulnerable = C1Group::sum('num_women_disability')
                       + C1Group::sum('num_widows')
                       + C1Group::sum('num_women_heads_hh');

        return view('component1.dashboard', compact('stats', 'groupsByCounty', 'genderData', 'trainingCompletion', 'gbvVulnerable', 'kpiStats'));

    }
}