<?php

namespace App\Http\Controllers\Component3;

use App\Http\Controllers\Controller;
use App\Models\Component3\C3HotlineRegister;
use App\Http\Requests\StoreC3HotlineRegisterRequest;
use Illuminate\Http\Request;

class C3HotlineRegisterController extends Controller
{
    public function index()
    {
        $registers = C3HotlineRegister::with('creator')
            ->latest('date_of_report')
            ->paginate(20);

        return view('component3.hotline.index', compact('registers'));
    }

    public function create()
    {
        return view('component3.hotline.create');
    }

    public function store(StoreC3HotlineRegisterRequest $request)
    {
        $data = $request->validated();
        $data['created_by'] = auth()->id();

        C3HotlineRegister::create($data);

        return redirect()->route('component3.hotline.index')
            ->with('success', 'Hotline incident registered successfully.');
    }

    public function show(C3HotlineRegister $hotlineRegister)
    {
        return view('component3.hotline.show', compact('hotlineRegister'));
    }
}