<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckComponent
{
    public function handle(Request $request, Closure $next, $componentId)
    {
        $user = Auth::user();

        if (!$user || !$user->hasComponent($componentId)) {
            abort(403, 'You do not have access to this component.');
        }

        // Optional: Set current component in session
        session(['current_component' => $componentId]);

        return $next($request);
    }
}