<?php

namespace App\Models\Component3;

use App\Models\User; 
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class C3HotlineRegister extends Model
{
    use HasFactory;

    protected $table = 'c3_hotline_registers';

    protected $fillable = [
        'incident_id', 'survivor_code', 'case_manager_code',
        'date_of_report', 'date_of_incident', 'date_of_birth', 'sex',
        'ethnicity', 'country_of_origin', 'civil_marital_status',
        'displacement_status_at_report', 'person_with_disability',
        'unaccompanied_or_separated_child', 'stage_of_displacement_at_incident',
        'incident_time_of_day', 'incident_location', 'incident_area',
        'incident_sub_area', 'incident_camp_town', 'gbv_type',
        'harmful_traditional_practice', 'money_goods_benefits_exchanged',
        'type_of_abduction', 'previously_reported_this_incident',
        'previous_gbv_incidents', 'number_of_alleged_perpetrators',
        'alleged_perpetrator_sex', 'nationality_of_alleged_perpetrator',
        'alleged_perpetrator_age_group', 'alleged_perpetrator_relationship_with_survivor',
        'main_occupation_of_alleged_perpetrator', 'referred_to_you_from',
        'safe_house_shelter', 'health_medical_services', 'psychosocial_services',
        'wants_legal_action', 'legal_assistance_service', 'police_other_security_actor',
        'livelihoods_program', 'child_protection_service', 'nfis',
        'consent_given_for_information_sharing', 'created_by'
    ];

    protected $casts = [
        'date_of_report'       => 'date',
        'date_of_incident'     => 'date',
        'date_of_birth'        => 'date',
        'person_with_disability' => 'boolean',
        'unaccompanied_or_separated_child' => 'boolean',
        'consent_given_for_information_sharing' => 'boolean',
        'wants_legal_action'   => 'boolean',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}