<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('c1_indicators', function (Blueprint $table) {
            $table->id();
            
            // KPI Information
            $table->string('kpi_name')->unique();
            
            // SeedLab Targets
            $table->integer('sl_target')->nullable();
            $table->text('sl_definition')->nullable();
            
            // GL Targets
            $table->integer('gl_target')->nullable();
            $table->text('gl_definition')->nullable();
            
            // Phase & Type
            $table->enum('phase', ['bootcamp', 'pitch', 'accelerator', 'capacity_building'])->nullable();
            $table->json('financing_type')->nullable()->comment('Array: equity, loan, etc.');
            
            $table->timestamps();
            
            // Index
            $table->index('phase');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('c1_indicators');
    }
};