<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('component3_call_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('serial_no')->nullable();
            $table->date('date');
            $table->time('call_in_time')->nullable();
            $table->string('caller_id', 50);
            $table->enum('gender', ['F', 'M']);
            $table->integer('age')->nullable();
            $table->boolean('person_with_disability')->default(false);
            $table->enum('residential_status', ['Refugee', 'Displaced', 'Resident']);
            
            // Location
            $table->string('state', 191);
            $table->string('county', 191);
            $table->string('payam', 191);
            $table->string('boma', 191)->nullable();

            // Incident Types (boolean flags)
            $table->boolean('denial_resources')->default(false);
            $table->boolean('rape_case')->default(false);
            $table->boolean('emotional_abuse')->default(false);
            $table->boolean('child_marriage')->default(false);
            $table->boolean('wife_beating')->default(false);

            $table->text('requested_need')->nullable();
            $table->text('actions_taken')->nullable();
            $table->string('referred_to')->nullable(); // Police, Hospital, etc.
            $table->boolean('follow_up_required')->default(false);
            $table->date('follow_up_date')->nullable();

            // IRI 3.1 – Survivor Satisfaction
            $table->boolean('satisfaction_feedback')->nullable(); // Yes/No

            $table->string('attendant_name');
            $table->foreignId('created_by')->constrained('users')->onDelete('restrict');
            $table->timestamps();

            $table->index([DB::raw('state(80)'), DB::raw('county(80)'), DB::raw('payam(80)')], 'c3_call_logs_location_index');
            $table->index('date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('component3_call_logs');
    }
};
