<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('c4_supports', function (Blueprint $table) {
            $table->id();
            
            // Polymorphic relationship
            $table->morphs('supportable'); // For linking to participants
            
            // Support Details
            $table->enum('type', ['training_material', 'grant', 'other']);
            $table->enum('source', ['sswseep', 'others'])->nullable();
            $table->decimal('value_amount', 10, 2)->default(0);
            $table->text('details')->nullable();
            $table->date('date_received')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index('supportable_type');
            $table->index('supportable_id');
            $table->index('type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('c4_supports');
    }
};