<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('c2_seedlab_beneficiaries', function (Blueprint $table) {
            $table->id();
            
            // Optional link to VSLA groups from Component 1
            $table->foreignId('group_id')->nullable()->constrained('c1_groups')->onDelete('set null');
            
            // Basic Information
            $table->integer('sn')->unique(); // Unique SN across SeedLab
            $table->string('full_name', 191);
            $table->enum('business_sector', ['Agriculture', 'Education', 'Healthcare', 'Real Estate', 'Services', 'Supply & Trading', 'Hospitality', 'Construction']);
            $table->string('business_type', 191)->nullable();
            $table->enum('residential_status', ['Host', 'Returnee', 'IDP']);
            $table->string('cohort_year', 50); // e.g., 'Cohort 1/25'
            $table->enum('training_centre', ['Acacia', 'Women Centre', 'Orange Corner']);
            $table->string('mobile_no', 20)->nullable();
            $table->string('county', 100)->nullable();
            $table->string('payam', 100)->nullable();
            $table->string('boma', 100)->nullable();
            $table->integer('age')->nullable();
            $table->enum('gender', ['Female', 'Male', 'Adol.Girl']);
            $table->string('education_level', 191)->nullable();
            
            // Capacity Building Modules
            $table->enum('module_1', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_2', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_3', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_4', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_5', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_6', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_7', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_8', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            
            // Participation & Verification
            $table->integer('woef_connect_participation')->default(0);
            $table->enum('received_certificate', ['Received', 'Not received'])->default('Not received');
            $table->enum('physical_verification', ['Yes', 'No'])->default('No');
            
            $table->timestamps();
            $table->softDeletes(); // For deleted_at
            
            // Indexes
            $table->index('group_id');
            $table->index('county');
            $table->index('cohort_year');
            $table->index('gender');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('c2_seedlab_beneficiaries');
    }
};