<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('c2_grants', function (Blueprint $table) {
            $table->id();

            // Polymorphic relationship → works for both SeedLab and GrowthLab (and future tracks)
            $table->morphs('grantable'); // creates: grantable_id (bigint unsigned) + grantable_type (string) + AUTO-ADDS THE INDEX

            // Bank & Approval
            $table->string('bank_name'); // you can change to enum later if you want
            $table->decimal('total_approved', 14, 2)->nullable()->comment('Total grant amount approved');

            // First Tranche
            $table->decimal('first_tranche_amount', 14, 2)->nullable();
            $table->date('first_tranche_date')->nullable();

            // Tranche 2
            $table->decimal('second_tranche_amount', 14, 2)->nullable();
            $table->date('second_tranche_date')->nullable();

            // Summary fields
            $table->decimal('total_received', 14, 2)->default(0)->comment('Auto-calculated or manual override');
            $table->enum('utilized_for_plan', ['Yes', 'No', 'Partial'])->default('No');
            $table->text('remarks')->nullable();

            $table->timestamps();
            $table->softDeletes();

            // Additional Indexes for performance (no duplicate for morphs)
            $table->index('bank_name');
            $table->index('first_tranche_date');
            $table->index('second_tranche_date');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('c2_grants');
    }
};