@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', $group->name)

@section('content')
<div class="container-fluid px-4 py-3">
    <!-- Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Group {{ $group->name }} Details
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('component1.dashboard') }}">Component 1 Dashboard</a></li>
                            <li class="breadcrumb-item active">Groups</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="text-success">{{ $group->name }}</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('component1.groups.index') }}">Groups</a></li>
                    <li class="breadcrumb-item active">{{ Str::limit($group->name, 30) }}</li>
                </ol>
            </nav>
        </div>
        <div>
            <a href="{{ route('component1.groups.edit', $group) }}" class="btn btn-outline-secondary me-2">
                Edit Group
            </a>
            <a href="{{ route('component1.members.create') }}?group_id={{ $group->id }}" class="btn btn-success">
                Add Member
            </a>
        </div>
    </div>

    <!-- Group Summary Card -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Total Members</h6>
                    <h3 class="text-success">{{ $group->members_count }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Active Members</h6>
                    <h3 class="text-success">{{ $group->members()->active()->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Formation Date</h6>
                    <h5 class="text-dark">{{ $group->date_formation->format('d M Y') }}</h5>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Group Nature</h6>
                    <span class="badge bg-{{ $group->nature == 'new' ? 'warning' : ($group->nature == 'progressing' ? 'info' : 'success') }} fs-6">
                        {{ ucfirst($group->nature) }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Group Details -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-light">
            <h5 class="mb-0">Group Details</h5>
        </div>
        <div class="card-body">
            <div class="row g-4">
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <th width="40%">State</th>
                            <td>{{ $group->state }}</td>
                        </tr>
                        <tr>
                            <th>County</th>
                            <td>{{ $group->county }}</td>
                        </tr>
                        <tr>
                            <th>Payam</th>
                            <td>{{ $group->payam }}</td>
                        </tr>
                        <tr>
                            <th>Establishing Org</th>
                            <td>{{ $group->establishing_org_name ?? '—' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <th>Establishment Type</th>
                            <td>{{ ucfirst($group->establishment_type) }}</td>
                        </tr>
                        <tr>
                            <th>VSLA Registration</th>
                            <td>{{ $group->vsla_registration_date?->format('d M Y') ?? '—' }}</td>
                        </tr>
                        <tr>
                            <th>Leadership</th>
                            <td>
                                <span class="badge bg-primary">
                                    {{ $group->leadership == 'adolescent_girl' ? 'Adolescent Girl' : 'Woman' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Snapshot Month</th>
                            <td>{{ \Carbon\Carbon::parse($group->month)->format('F Y') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Members -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Recent Members ({{ $group->members()->active()->count() }} active)</h5>
            <a href="{{ route('component1.members.index') }}?group_id={{ $group->id }}" class="btn btn-sm btn-outline-success">
                View All Members
            </a>
        </div>
        <div class="card-body p-0">
            @if($group->members->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Gender</th>
                                <th>Age</th>
                                <th>Role</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($group->members as $member)
                                <tr>
                                    <td>{{ $member->name }}</td>
                                    <td>
                                        <span class="badge bg-{{ $member->gender == 'female' ? 'pink' : 'info' }}">
                                            {{ ucfirst($member->gender) }}
                                        </span>
                                    </td>
                                    <td>{{ $member->age }}</td>
                                    <td>
                                        @if($member->exec_committee)
                                            <span class="badge bg-success">Exec Committee</span>
                                        @else
                                            —
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $member->active ? 'success' : 'secondary' }}">
                                            {{ $member->active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5 text-muted">
                    No members added yet.
                </div>
            @endif
        </div>
    </div>
</div>
@endsection