@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
@endphp

@extends($layout)

@section('title', $weof->name . ' – WEOF')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="text-success">{{ $weof->name }}</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('component1.weof.index') }}">WEOF Beneficiaries</a></li>
                    <li class="breadcrumb-item active">{{ Str::limit($weof->name, 30) }}</li>
                </ol>
            </nav>
        </div>
        <div>
            <a href="{{ route('component1.weof.edit', $weof) }}" class="btn btn-outline-secondary me-2">
                Edit Beneficiary
            </a>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">WEOF ID</h6>
                    <h4 class="text-success">{{ $weof->woef_id }}</h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Business</h6>
                    <h5 class="text-dark">{{ $weof->business_name }}</h5>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Revenue (SSP)</h6>
                    <h4 class="text-success">{{ number_format($weof->monthly_revenue, 2) }}</h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Participation</h6>
                    <span class="badge bg-{{ $weof->participation == '1_completed' ? 'success' : ($weof->participation == 'successful' ? 'primary' : 'warning') }} fs-5">
                        {{ $weof->participation_label }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- GBV Vulnerability Alert -->
    @if($weof->is_gbv_vulnerable)
        <div class="alert alert-warning d-flex align-items-center mb-4">
            <i class="bi bi-exclamation-triangle-fill me-2"></i>
            <div>
                <strong>GBV Risk:</strong> This beneficiary is flagged as vulnerable
                @if(in_array($weof->marital_status, ['widowed', 'divorced'])) ({{ ucfirst($weof->marital_status) }})@endif
                @if($weof->resident_status == 'idp') (IDP)@endif
                @if($weof->resident_status == 'returnee') (Returnee)@endif
            </div>
        </div>
    @endif

    <!-- Personal & Business Info -->
    <div class="row g-4 mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Personal Information</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless mb-0">
                        <tr>
                            <th width="40%">Age</th>
                            <td>{{ $weof->age }}</td>
                        </tr>
                        <tr>
                            <th>Marital Status</th>
                            <td>{{ ucwords(str_replace('_', ' ', $weof->marital_status)) }}</td>
                        </tr>
                        <tr>
                            <th>Resident Status</th>
                            <td>{{ ucfirst($weof->resident_status) }}</td>
                        </tr>
                        <tr>
                            <th>Education</th>
                            <td>{{ ucwords(str_replace('_', ' ', $weof->education)) }}</td>
                        </tr>
                        <tr>
                            <th>Phone</th>
                            <td>{{ $weof->phone_no ?: '—' }}</td>
                        </tr>
                        <tr>
                            <th>Location</th>
                            <td>{{ $weof->county }} / {{ $weof->payam }}</td>
                        </tr>
                        <tr>
                            <th>Group</th>
                            <td>
                                @if($weof->group)
                                    <a href="{{ route('component1.groups.show', $weof->group) }}">{{ $weof->group->name }}</a>
                                @else
                                    —
                                @endif
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Business Details</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless mb-0">
                        <tr>
                            <th width="40%">Name</th>
                            <td>{{ $weof->business_name }}</td>
                        </tr>
                        <tr>
                            <th>Category</th>
                            <td>{{ $weof->business_category }}</td>
                        </tr>
                        <tr>
                            <th>Type</th>
                            <td>{{ ucfirst($weof->business_type) }}</td>
                        </tr>
                        <tr>
                            <th>Established</th>
                            <td>{{ $weof->establishment_year }}</td>
                        </tr>
                        <tr>
                            <th>Registered</th>
                            <td>{{ $weof->registration_status ? 'Yes' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>Target Customers</th>
                            <td>{{ $weof->target_customers }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Employment Growth -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-light">
            <h5 class="mb-0">Employment Growth</h5>
        </div>
        <div class="card-body">
            <div class="row text-center">
                <div class="col-md-6">
                    <h6 class="text-muted">Before Program</h6>
                    <div class="d-flex justify-content-center gap-4">
                        <div>
                            <h4 class="text-primary">{{ $weof->employees_before_male }}</h4>
                            <small>Male</small>
                        </div>
                        <div>
                            <h4 class="text-pink">{{ $weof->employees_before_female }}</h4>
                            <small>Female</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <h6 class="text-success">Now</h6>
                    <div class="d-flex justify-content-center gap-4">
                        <div>
                            <h4 class="text-primary">{{ $weof->employees_now_male }}</h4>
                            <small>Male</small>
                        </div>
                        <div>
                            <h4 class="text-pink">{{ $weof->employees_now_female }}</h4>
                            <small>Female</small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-3 text-center">
                <small class="text-success">
                    <strong>+{{ $weof->total_employees_now - $weof->total_employees_before }}</strong> jobs created
                </small>
            </div>
        </div>
    </div>

    <!-- Financing Sources -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-light">
            <h5 class="mb-0">Financing Sources</h5>
        </div>
        <div class="card-body">
            <div class="row g-3">
                @foreach(['equity' => 'Equity', 'loan' => 'Loan', 'debt' => 'Debt', 'grant' => 'Grant'] as $key => $label)
                    <div class="col-md-3">
                        <div class="text-center p-3 rounded {{ in_array($key, $weof->financing_sources ?? []) ? 'bg-light-success border' : 'bg-light' }}">
                            <i class="bi bi-check-circle-fill text-success fs-3"></i>
                            <p class="mb-0 mt-2 small">{{ $label }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Training Progress -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Training Completed ({{ $weof->training_completed_count }}/5)</h5>
            <div class="progress" style="width: 200px; height: 20px;">
                <div class="progress-bar bg-success" style="width: {{ ($weof->training_completed_count / 5) * 100 }}%"></div>
            </div>
        </div>
        <div class="card-body">
            <div class="row g-3">
                @foreach([
                    'functional_literacy' => 'Functional Literacy',
                    'vsla_ops' => 'VSLA Operations',
                    'business_dev' => 'Business Dev',
                    'digital_literacy' => 'Digital Literacy',
                    'specialized' => 'Specialized'
                ] as $key => $label)
                    <div class="col-md">
                        <div class="text-center p-2 rounded {{ in_array($key, $weof->training_type ?? []) ? 'bg-light-success' : 'bg-light' }} border">
                            <p class="mb-0 small">{{ $label }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Grants & Accelerator -->
    <div class="row g-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Grant Disbursement</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless mb-0">
                        <tr>
                            <th>1st Tranche</th>
                            <td><strong>SSP {{ number_format($weof->grant_1st_tranche ?? 0, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <th>2nd Tranche</th>
                            <td><strong>SSP {{ number_format($weof->grant_2nd_tranche ?? 0, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <th>Total</th>
                            <td><strong class="text-success">SSP {{ number_format(($weof->grant_1st_tranche ?? 0) + ($weof->grant_2nd_tranche ?? 0), 2) }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Accelerator & Validation</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless mb-0">
                        <tr>
                            <th>Accelerator Participation</th>
                            <td>{{ $weof->accelerator_participation ? 'Yes' : 'No' }}</td>
                        </tr>
                        @if($weof->accelerator_participation)
                        <tr>
                            <th>Graduated</th>
                            <td>{{ $weof->accelerator_graduation ? 'Yes' : 'No' }}</td>
                        </tr>
                        @endif
                        <tr>
                            <th>Onsite Validation</th>
                            <td>{{ $weof->onsite_validation ? 'Yes' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>WEOF Connect</th>
                            <td>{{ $weof->participation_woef_connect ? 'Yes' : 'No' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<style>
    .bg-light-success { background-color: rgba(40, 167, 69, 0.1) !important; }
    .text-pink { color: #d63384 !important; }
</style>
@endpush