@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component4.layouts.app';
@endphp

@extends($layout)

@section('content')
<h3><i class="bi bi-person-plus"></i> Register New Training Participant</h3>

<div class="card shadow-sm mt-4">
    <div class="card-body">
        <form action="{{ route('component4.store') }}" method="POST">
            @csrf
            <div class="row g-3">
                <div class="col-md-2">
                    <label>S/N</label>
                    <input type="number" name="serial_no" class="form-control" value="{{ old('serial_no') }}">
                </div>
                <div class="col-md-5">
                    <label>Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" required>
                    @error('name') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
                <div class="col-md-5">
                    <label>Organization</label>
                    <input type="text" name="organization" class="form-control" value="{{ old('organization') }}">
                </div>

                <div class="col-md-4">
                    <label>Designation</label>
                    <input type="text" name="designation" class="form-control" value="{{ old('designation') }}">
                </div>
                <div class="col-md-4">
                    <label>Gender <span class="text-danger">*</span></label>
                    <select name="gender" class="form-select @error('gender') is-invalid @enderror" required>
                        <option value="">-- Select --</option>
                        <option value="female" {{ old('gender')=='female' ? 'selected':'' }}>Female</option>
                        <option value="male" {{ old('gender')=='male' ? 'selected':'' }}>Male</option>
                        <option value="other" {{ old('gender')=='other' ? 'selected':'' }}>Other</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label>State/Province <span class="text-danger">*</span></label>
                    <input type="text" name="state_province" class="form-control @error('state_province') is-invalid @enderror" value="{{ old('state_province') }}" required>
                </div>

                <div class="col-md-6">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="{{ old('start_date') }}">
                </div>
                <div class="col-md-6">
                    <label>Completion Date</label>
                    <input type="date" name="completion_date" class="form-control" value="{{ old('completion_date') }}">
                </div>
            </div>

            <hr class="my-4">

            <h5>Training Modules Completed</h5>
            <div class="row">
                @php $modules = [
                    'project_management' => 'Project Management',
                    'grm' => 'Grievance Redress Mechanism (GRM)',
                    'monitoring_evaluation' => 'Monitoring & Evaluation',
                    'gbv_programming' => 'GBV Programming',
                    'gender_equality' => 'Gender Equality',
                    'resource_mobilization' => 'Resource Mobilization',
                    'leadership_management' => 'Leadership & Management',
                ]; @endphp

                @foreach($modules as $key => $label)
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="trained_{{ $key }}" value="1" id="{{ $key }}">
                        <label class="form-check-label" for="{{ $key }}">{{ $label }}</label>
                    </div>
                </div>
                @endforeach
            </div>

            <div class="mt-4">
                <label>Comment / Remark</label>
                <textarea name="comment" class="form-control" rows="3">{{ old('comment') }}</textarea>
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-success btn-lg">Save Participant</button>
                <a href="{{ route('component4.index') }}" class="btn btn-secondary btn-lg">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection