<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Component1\C1DashboardController;
use App\Http\Controllers\Component1\C1GroupController;
use App\Http\Controllers\Component1\C1MemberController;
use App\Http\Controllers\Component1\C1WeofBeneficiaryController;
use App\Http\Controllers\Component3\C3HotlineRegisterController;
use App\Http\Controllers\Component3\C3PreventionRegisterController;
use App\Http\Controllers\Component2\C2SeedlabController;
use App\Http\Controllers\Component2\C2GrowthlabController;
use App\Http\Controllers\Component2\C2WeofBeneficiaryController;
use App\Http\Controllers\Component2\C2DashboardController;
use App\Http\Controllers\Component4\C4ParticipantController;
use Illuminate\Support\Facades\Route;
use App\Http\Middleware\CheckRole;

// Public
// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/', function () {
    return redirect()->route('login');
});

// In your routes/web.php, add this route at the root level
Route::get('/home', function () {
    if (auth()->user()->role === 'super_admin') {
        return redirect()->route('admin.dashboard');
    } elseif (auth()->user()->role === 'component_1_user') {
        return redirect()->route('component1.dashboard');
    }elseif (auth()->user()->role === 'component_2_user') {
        return redirect()->route('component2.index');
    }elseif (auth()->user()->role === 'component_3_user') {
        return redirect()->route('component3.dashboard');
    }elseif (auth()->user()->role === 'component_4_user') {
        return redirect()->route('component4.index');
    }
    // Add more role checks as needed
})->name('home');

// Auth Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Protected Routes (will add middleware later)
// In routes/web.php

Route::middleware(['auth'])->group(function () {

    // === SUPER ADMIN AREA ===
    Route::prefix('admin')->name('admin.')->middleware('role:super_admin')->group(function () {

    // Dashboard (moved from inline closure to controller)
    Route::get('/dashboard', [AdminController::class, 'dashboard'])
         ->name('dashboard');

    // User Management
    Route::get('/users', [AdminController::class, 'usersIndex'])
         ->name('users.index');

    Route::get('/users/create', [AdminController::class, 'usersCreate'])
         ->name('users.create');

    Route::post('/users', [AdminController::class, 'usersStore'])
         ->name('users.store');

    

    // You can add edit/update/delete later
    });

    // Component 1
    Route::prefix('component1')
     ->name('component1.')
     ->middleware(['auth', 'component:1'])
     ->group(function () {

    Route::get('/dashboard', C1DashboardController::class)
         ->name('dashboard');
    Route::get('/vsla-report', [App\Http\Controllers\Component1\VslaReportController::class, 'index'])
         ->name('vsla.report');
    Route::get('/component1/vsla-report/export', [App\Http\Controllers\Component1\VslaReportController::class, 'export'])
     ->name('component1.vsla.report.export');
    
    // === Groups CRUD ===
    Route::resource('groups', C1GroupController::class);
    // === Members CRUD ===
    Route::resource('members', C1MemberController::class);
    // === WEOF Beneficiaries CRUD ===
    Route::resource('weof', C1WeofBeneficiaryController::class);
    
    });

    // Component 2 (example)
    // Route::prefix('component2')->name('component2.')->middleware('component:2')->group(function () {
    //     Route::get('/dashboard', function () {
    //         return view('component2.dashboard');
    //     })->name('dashboard');
    // });

    Route::prefix('component2')->name('component2.')->middleware(['auth', 'component:2'])->group(function () {
        Route::get('/', [App\Http\Controllers\Component2\C2WeofBeneficiaryController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\Component2\C2WeofBeneficiaryController::class, 'create'])->name('create');
        Route::post('/', [App\Http\Controllers\Component2\C2WeofBeneficiaryController::class, 'store'])->name('store');
        Route::get('/{beneficiary}/edit', [App\Http\Controllers\Component2\C2WeofBeneficiaryController::class, 'edit'])->name('edit');
        Route::put('/{beneficiary}', [App\Http\Controllers\Component2\C2WeofBeneficiaryController::class, 'update'])->name('update');
        Route::delete('/{beneficiary}', [App\Http\Controllers\Component2\C2WeofBeneficiaryController::class, 'destroy'])->name('destroy');
        // In your c2 route group
        Route::get('/export', [App\Http\Controllers\Component2\C2WeofBeneficiaryController::class, 'export'])->name('export');
        Route::get('/dashboard', [App\Http\Controllers\Component2\C2WeofBeneficiaryController::class, 'dashboard'])->name('dashboard');
    });

    Route::prefix('component2/growthlab')->name('component2.growthlab.')->middleware(['auth', 'component:2'])->group(function () {
        Route::get('/', [App\Http\Controllers\Component2\C2GrowthlabController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\Component2\C2GrowthlabController::class, 'create'])->name('create');
        Route::post('/', [App\Http\Controllers\Component2\C2GrowthlabController::class, 'store'])->name('store');
        Route::get('/{business}/edit', [App\Http\Controllers\Component2\C2GrowthlabController::class, 'edit'])->name('edit');
        Route::put('/{business}', [App\Http\Controllers\Component2\C2GrowthlabController::class, 'update'])->name('update');
        Route::delete('/{business}', [App\Http\Controllers\Component2\C2GrowthlabController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('component2/seedlab')->name('component2.seedlab.')->middleware(['auth', 'component:2'])->group(function () {
        Route::get('/', [App\Http\Controllers\Component2\C2SeedlabController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\Component2\C2SeedlabController::class, 'create'])->name('create');
        Route::post('/', [App\Http\Controllers\Component2\C2SeedlabController::class, 'store'])->name('store');
        Route::get('/{beneficiary}/edit', [App\Http\Controllers\Component2\C2SeedlabController::class, 'edit'])->name('edit');
        Route::put('/{beneficiary}', [App\Http\Controllers\Component2\C2SeedlabController::class, 'update'])->name('update');
        Route::delete('/{beneficiary}', [App\Http\Controllers\Component2\C2SeedlabController::class, 'destroy'])->name('destroy');
    });


    // Component 3
    Route::prefix('component3')
     ->name('component3.')
     ->middleware(['auth', 'component:3'])
     ->group(function () {

    // === Hotline Registers CRUD ===
    Route::resource('hotline', App\Http\Controllers\Component3\C3HotlineRegisterController::class)
        ->except(['edit', 'update', 'destroy']);

    Route::get('/prevention/reports', [App\Http\Controllers\Component3\C3PreventionRegisterController::class, 'reports'])->name('prevention.reports');

    Route::get('/dashboard', [\App\Http\Controllers\Component3\DashboardController::class, 'index'])
     ->name('dashboard');
    
    // === Prevention Registers CRUD ===
    Route::resource('prevention', App\Http\Controllers\Component3\C3PreventionRegisterController::class)
        ->except(['edit', 'update', 'destroy']);    

    Route::resource('call-log', App\Http\Controllers\Component3\CallLogController::class)->except(['edit','update','destroy']);
    Route::resource('referral', App\Http\Controllers\Component3\ReferralRegisterController::class)->except(['edit','update','destroy']);

    Route::get('/export/pdf', [App\Http\Controllers\Component3\ExportController::class, 'pdf'])
     ->name('export.pdf');
    Route::get('/export/excel', [App\Http\Controllers\Component3\ExportController::class, 'excel'])
     ->name('export.excel');
    
    });

    // Component 4 Routes
    Route::prefix('component4')->name('component4.')->middleware(['auth', 'component:4'])->group(function () {
        Route::get('/', [App\Http\Controllers\Component4\C4ParticipantController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\Component4\C4ParticipantController::class, 'create'])->name('create');
        Route::post('/store', [App\Http\Controllers\Component4\C4ParticipantController::class, 'store'])->name('store');
        Route::get('/{participant}/edit', [App\Http\Controllers\Component4\C4ParticipantController::class, 'edit'])->name('edit');
        Route::put('/{participant}', [App\Http\Controllers\Component4\C4ParticipantController::class, 'update'])->name('update');
        Route::delete('/{participant}', [App\Http\Controllers\Component4\C4ParticipantController::class, 'destroy'])->name('destroy');
        Route::get('/export', [App\Http\Controllers\Component4\C4ParticipantController::class, 'export'])->name('export');
    });
});