<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
?>



<?php $__env->startSection('title', 'SeedLab Beneficiaries'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        SeedLab Beneficiaries Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('component2.dashboard')); ?>">Component 2 Dashboard</a></li>
                            <li class="breadcrumb-item active">SeedLab Beneficiaries</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fas fa-seedling"></i> SeedLab Beneficiaries
                    </h4>
                    <a href="<?php echo e(route('component2.seedlab.create')); ?>" class="btn btn-light btn-sm">
                        <i class="fas fa-plus"></i> Register New Beneficiary
                    </a>
                </div>

                <div class="card-body">
                    <!-- Filters -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-3">
                            <input type="text" id="search" class="form-control" placeholder="Search name, business, county...">
                        </div>
                        <div class="col-md-2">
                            <select id="sectorFilter" class="form-select">
                                <option value="">All Sectors</option>
                                <?php $__currentLoopData = ['Agriculture','Education','Healthcare','Real Estate','Services','Supply & Trading','Hospitality','Construction']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sector): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($sector); ?>"><?php echo e($sector); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="cohortFilter" class="form-select">
                                <option value="">All Cohorts</option>
                                <option value="Cohort 1/25">Cohort 1/25</option>
                                <option value="Cohort 2/25">Cohort 2/25</option>
                                <option value="Cohort 1/26">Cohort 1/26</option>
                                <option value="Cohort 2/26">Cohort 2/26</option>
                                <option value="Cohort 3/26">Cohort 3/26</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="genderFilter" class="form-select">
                                <option value="">All Genders</option>
                                <option value="Female">Female</option>
                                <option value="Male">Male</option>
                                <option value="Adol.Girl">Adolescent Girl</option>
                            </select>
                        </div>
                        <div class="col-md-3 text-end">
                            <button id="resetFilters" class="btn btn-outline-secondary">
                                <i class="fas fa-sync"></i> Reset Filters
                            </button>
                        </div>
                    </div>

                    <!-- Quick Stats -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card text-white bg-primary">
                                <div class="card-body text-center">
                                    <h5><?php echo e($totalBeneficiaries); ?></h5>
                                    <p class="mb-0">Total Registered</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-pink">
                                <div class="card-body text-center">
                                    <h5><?php echo e($femaleCount); ?></h5>
                                    <p class="mb-0">Women & Girls</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-info">
                                <div class="card-body text-center">
                                    <h5><?php echo e($withGrant); ?></h5>
                                    <p class="mb-0">Received Grant</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-white bg-success">
                                <div class="card-body text-center">
                                    <h5>SSP <?php echo e(number_format($totalDisbursed, 0)); ?></h5>
                                    <p class="mb-0">Total Disbursed</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- DataTable -->
                    <div class="table-responsive">
                        <table class="table table-hover align-middle" id="seedlabTable">
                            <thead class="table-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Beneficiary</th>
                                    <th>Sector</th>
                                    <th>Cohort</th>
                                    <th>Gender</th>
                                    <th>County</th>
                                    <th>Modules Completed</th>
                                    <th>Grant</th>
                                    <th>Verification</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><strong><?php echo e($b->sn); ?></strong></td>
                                    <td>
                                        <div><strong><?php echo e($b->full_name); ?></strong></div>
                                        <small class="text-muted"><?php echo e($b->business_type ?? 'Individual'); ?></small>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary"><?php echo e($b->business_sector); ?></span>
                                    </td>
                                    <td><span class="badge bg-secondary"><?php echo e($b->cohort_year); ?></span></td>
                                    <td>
                                        <?php if($b->gender === 'Female'): ?>
                                            <i class="fas fa-female text-pink"></i>
                                        <?php elseif($b->gender === 'Adol.Girl'): ?>
                                            <i class="fas fa-child text-purple"></i>
                                        <?php else: ?>
                                            <i class="fas fa-male text-blue"></i>
                                        <?php endif; ?>
                                        <?php echo e($b->gender); ?>

                                    </td>
                                    <td><?php echo e($b->county ?? '-'); ?></td>
                                    <td>
                                        <?php
                                            $completed = collect(['1','2','3','4','5','6','7','8'])
                                                ->filter(fn($m) => $b["module_$m"] === 'Completed')
                                                ->count();
                                        ?>
                                        <span class="badge bg-<?php echo e($completed >= 8 ? 'success' : ($completed >= 4 ? 'warning' : 'secondary')); ?>">
                                            <?php echo e($completed); ?>/8
                                        </span>
                                    </td>
                                    <td>
                                        <?php if($b->grant): ?>
                                            <?php if($b->grant->total_received > 0): ?>
                                                <span class="badge bg-success">SSP <?php echo e(number_format($b->grant->total_received)); ?></span>
                                            <?php else: ?>
                                                <span class="badge bg-warning">Approved</span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="badge bg-light text-dark">No Grant</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo e($b->physical_verification === 'Yes' ? 'bg-success' : 'bg-danger'); ?>">
                                            <?php echo e($b->physical_verification === 'Yes' ? 'Verified' : 'Pending'); ?>

                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <a href="<?php echo e(route('component2.seedlab.edit', $b)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('component2.seedlab.destroy', $b)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger"
                                                    onclick="return confirm('Delete this beneficiary?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="mt-3">
                        <?php echo e($beneficiaries->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- DataTables Script -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.min.js"></script>
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.bootstrap5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/2.0.8/css/dataTables.bootstrap5.min.css">

<script>
$(document).ready(function() {
    const table = $('#seedlabTable').DataTable({
        pageLength: 25,
        responsive: true,
        order: [[0, 'asc']],
        columnDefs: [{ orderable: false, targets: 9 }]
    });

    $('#search').on('keyup', function() {
        table.search(this.value).draw();
    });

    $('#sectorFilter, #cohortFilter, #genderFilter').on('change', function() {
        table.column(2).search($('#sectorFilter').val());
        table.column(3).search($('#cohortFilter').val());
        table.column(4).search($('#genderFilter').val());
        table.draw();
    });

    $('#resetFilters').on('click', function() {
        $('#search, #sectorFilter, #cohortFilter, #genderFilter').val('');
        table.search('').columns().search('').draw();
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component2/seedlab/index.blade.php ENDPATH**/ ?>