<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component4.layouts.app';
?>



<?php $__env->startSection('content'); ?>
<h3><i class="bi bi-person-plus"></i> Register New Training Participant</h3>

<div class="card shadow-sm mt-4">
    <div class="card-body">
        <form action="<?php echo e(route('component4.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row g-3">
                <div class="col-md-2">
                    <label>S/N</label>
                    <input type="number" name="serial_no" class="form-control" value="<?php echo e(old('serial_no')); ?>">
                </div>
                <div class="col-md-5">
                    <label>Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('name')); ?>" required>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-md-5">
                    <label>Organization</label>
                    <input type="text" name="organization" class="form-control" value="<?php echo e(old('organization')); ?>">
                </div>

                <div class="col-md-4">
                    <label>Designation</label>
                    <input type="text" name="designation" class="form-control" value="<?php echo e(old('designation')); ?>">
                </div>
                <div class="col-md-4">
                    <label>Gender <span class="text-danger">*</span></label>
                    <select name="gender" class="form-select <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                        <option value="">-- Select --</option>
                        <option value="female" <?php echo e(old('gender')=='female' ? 'selected':''); ?>>Female</option>
                        <option value="male" <?php echo e(old('gender')=='male' ? 'selected':''); ?>>Male</option>
                        <option value="other" <?php echo e(old('gender')=='other' ? 'selected':''); ?>>Other</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label>State/Province <span class="text-danger">*</span></label>
                    <input type="text" name="state_province" class="form-control <?php $__errorArgs = ['state_province'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('state_province')); ?>" required>
                </div>

                <div class="col-md-6">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?php echo e(old('start_date')); ?>">
                </div>
                <div class="col-md-6">
                    <label>Completion Date</label>
                    <input type="date" name="completion_date" class="form-control" value="<?php echo e(old('completion_date')); ?>">
                </div>
            </div>

            <hr class="my-4">

            <h5>Training Modules Completed</h5>
            <div class="row">
                <?php $modules = [
                    'project_management' => 'Project Management',
                    'grm' => 'Grievance Redress Mechanism (GRM)',
                    'monitoring_evaluation' => 'Monitoring & Evaluation',
                    'gbv_programming' => 'GBV Programming',
                    'gender_equality' => 'Gender Equality',
                    'resource_mobilization' => 'Resource Mobilization',
                    'leadership_management' => 'Leadership & Management',
                ]; ?>

                <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="trained_<?php echo e($key); ?>" value="1" id="<?php echo e($key); ?>">
                        <label class="form-check-label" for="<?php echo e($key); ?>"><?php echo e($label); ?></label>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="mt-4">
                <label>Comment / Remark</label>
                <textarea name="comment" class="form-control" rows="3"><?php echo e(old('comment')); ?></textarea>
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-success btn-lg">Save Participant</button>
                <a href="<?php echo e(route('component4.index')); ?>" class="btn btn-secondary btn-lg">Cancel</a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component4/create.blade.php ENDPATH**/ ?>