<?php

namespace App\Http\Controllers\Component2;

use App\Http\Controllers\Controller;
use App\Models\C2SeedlabBeneficiary;
use App\Models\C2Grant;
use Illuminate\Http\Request;

class C2SeedlabController extends Controller{
    public function index()
    {
        $beneficiaries = C2SeedlabBeneficiary::with('grant')
            ->latest()
            ->paginate(50);

        return view('component2.seedlab.index', [
            'beneficiaries' => $beneficiaries,
            'totalBeneficiaries' => C2SeedlabBeneficiary::count(),
            'femaleCount' => C2SeedlabBeneficiary::whereIn('gender', ['Female', 'Adol.Girl'])->count(),
            'withGrant' => C2SeedlabBeneficiary::whereHas('grant')->count(),
            'totalDisbursed' => C2Grant::where('grantable_type', C2SeedlabBeneficiary::class)
                                    ->sum('total_received'),
        ]);
    }

    public function create()
    {
        return view('component2.seedlab.create');
    }
    public function store(Request $request)
    {
        $validated = $request->validate([
            'sn' => 'required|integer|unique:c2_seedlab_beneficiaries,sn',
            'full_name' => 'required|string|max:191',
            'business_sector' => 'required',
            'cohort_year' => 'required',
            // add more rules as needed
        ]);

        $beneficiary = C2SeedlabBeneficiary::create($request->except('grant'));

        if ($request->filled('grant')) {
            $beneficiary->grant()->updateOrCreate([], $request->input('grant'));
        }

        return redirect()->route('component2.seedlab.index')->with('success', 'Beneficiary registered successfully!');
    }

    public function edit(C2SeedlabBeneficiary $beneficiary)
    {
        return view('component2.seedlab.create', compact('beneficiary'));
    }

    public function update(Request $request, C2SeedlabBeneficiary $beneficiary)
    {
        $beneficiary->update($request->except('grant'));

        if ($request->filled('grant')) {
            $beneficiary->grant()->updateOrCreate([], $request->input('grant'));
        }

        return back()->with('success', 'Beneficiary updated successfully!');
    }

    public function destroy(C2SeedlabBeneficiary $beneficiary)
    {
        $beneficiary->delete();
        return back()->with('success', 'Beneficiary deleted successfully!');
    }
}