<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class C2Grant extends Model
{
    use SoftDeletes;

    protected $guarded = ['id'];

    protected $casts = [
        'first_tranche_date'  => 'date',
        'second_tranche_date' => 'date',
        'total_approved'      => 'decimal:2',
        'first_tranche_amount'=> 'decimal:2',
        'second_tranche_amount'=> 'decimal:2',
        'total_received'      => 'decimal:2',
    ];

    // Reverse polymorphic relation
    public function grantable(): MorphTo
    {
        return $this->morphTo();
    }
}