<?php

namespace App\Models\Component3;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;

class C3PreventionRegister extends Model
{
    use HasFactory;

    protected $table = 'c3_prevention_registers';

    protected $fillable = [
        'serial_no', 'name_of_community_member', 'gender', 'age',
        'category_of_participants', 'person_with_disability', 'refugee_or_displaced',
        'state', 'county', 'payam', 'boma',
        'prevention_messages', 'referral_pathways', 'conflict_resolution',
        'male_engagement_dialogue', 'positive_masculinity_activity',
        'received_iec_materials', 'received_radio_talkshows',
        'other_activities_support', 'session_date', 'created_by'
    ];

    protected $casts = [
        'session_date' => 'date',
        'person_with_disability' => 'boolean',
        'refugee_or_displaced'   => 'boolean',
        'prevention_messages'    => 'boolean',
        'referral_pathways'      => 'boolean',
        'conflict_resolution'   => 'boolean',
        'male_engagement_dialogue' => 'boolean',
        'positive_masculinity_activity' => 'boolean',
        'received_iec_materials' => 'boolean',
        'received_radio_talkshows' => 'boolean',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}