<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('c1_members', function (Blueprint $table) {
            $table->id();
            
            // Foreign Key
            $table->foreignId('group_id')->constrained('c1_groups')->onDelete('cascade');
            
            // Basic Information
            $table->integer('serial_no')->comment('Per-group serial number');
            $table->string('name');
            $table->enum('gender', ['female', 'male']);
            $table->integer('age');
            $table->boolean('active')->default(true);
            
            // Roles & Status
            $table->boolean('exec_committee')->default(false);
            $table->boolean('disability_status')->default(false)->comment('GBV flag');
            $table->enum('marital_status', ['married', 'not_married', 'divorced'])->nullable();
            $table->boolean('head_household')->default(false)->comment('GBV flag');
            
            // Household Composition
            $table->integer('num_hh_members_total')->default(0);
            $table->integer('num_hh_female_adult')->default(0);
            $table->integer('num_hh_female_adol')->default(0)->comment('14-24 years');
            $table->integer('num_hh_male_adult')->default(0);
            $table->integer('num_hh_male_adol')->default(0)->comment('14-24 years');
            
            // Core Trainings (Boolean flags)
            $table->boolean('completed_core_1')->default(false)->comment('Functional literacy/financial mgmt');
            $table->boolean('completed_core_2')->default(false)->comment('VSLA ops/leadership');
            $table->boolean('completed_core_3')->default(false)->comment('Business dev/entrepreneurship');
            $table->boolean('completed_core_4')->default(false)->comment('Digital/info literacy');
            
            // Specialized Training
            $table->boolean('received_specialized_1')->default(false)->comment('Vocational/climate/smart ag/advanced VSLA/market');
            $table->text('specialized_1_details')->nullable();
            
            // Support Received
            $table->boolean('received_in_kind')->default(false);
            $table->enum('in_kind_source', ['sswseep', 'others'])->nullable();
            $table->boolean('received_productive_equip')->default(false);
            $table->enum('equip_source', ['sswseep', 'others'])->nullable();
            
            // Business & Savings
            $table->boolean('started_new_business')->default(false);
            $table->boolean('actively_saving_monthly')->default(false);
            $table->decimal('total_savings', 10, 2)->default(0)->comment('Quarterly');
            $table->decimal('outstanding_loan', 10, 2)->default(0);
            
            // Snapshot Date
            $table->date('month')->nullable()->comment('For periodic snapshots');
            
            $table->timestamps();
            
            // Indexes
            $table->index('group_id');
            $table->index(['group_id', 'serial_no']);
            $table->index('gender');
            $table->index('active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('c1_members');
    }
};