<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add role field
            $table->enum('role', ['super_admin', 'component_1_user', 'component_2_user', 'component_3_user'])
                  ->default('component_1_user')
                  ->after('email');
            
            // Add component ID for future multi-component support
            $table->integer('component_id')
                  ->default(1)
                  ->after('role')
                  ->comment('1=Component1, 2=Component2, 3=Component3');
            
            // Add index for faster queries
            $table->index(['role', 'component_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropIndex(['role', 'component_id']);
            $table->dropColumn(['role', 'component_id']);
        });
    }
};