@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', 'VSLA/Community Groups')

@section('content')
<div class="container-fluid px-4 py-3">
    <!-- Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        VSLA/Community Groups
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('component1.dashboard') }}">Component 1 Dashboard</a></li>
                            <li class="breadcrumb-item active">Groups</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="text-success">Registered VSLA/Community Groups</h3>
        <a href="{{ route('component1.groups.create') }}" class="btn btn-success">
            Register New VSLA/Community Group
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Name</th>
                            <th>Nature</th>
                            <th>County / Payam</th>
                            <th>Members</th>
                            <th>Formation</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($groups as $group)
                            <tr>
                                <td>{{ $group->name }}</td>
                                <td>
                                    <span class="badge bg-{{ $group->nature == 'new' ? 'warning' : ($group->nature == 'progressing' ? 'info' : 'success') }}">
                                        {{ ucfirst($group->nature) }}
                                    </span>
                                </td>
                                <td>{{ $group->county }} / {{ $group->payam }}</td>
                                <td>{{ $group->members_count }}</td>
                                <td>{{ $group->date_formation->format('M Y') }}</td>
                                <td>
                                    <a href="{{ route('component1.groups.show', $group) }}" class="btn btn-sm btn-outline-primary">View</a>
                                    <a href="{{ route('component1.groups.edit', $group) }}" class="btn btn-sm btn-outline-secondary">Edit</a>
                                    <form action="{{ route('component1.groups.destroy', $group) }}" method="POST" class="d-inline">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this group?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">
                                    No groups registered yet.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="mt-4">
        {{ $groups->links() }}
    </div>
</div>
@endsection