@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', 'Register New Group')

@section('content')
<div class="container-fluid py-4">
    <h3 class="text-success mb-4">Register New VSLA/Community Group</h3>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <form action="{{ route('component1.groups.store') }}" method="POST">
                @csrf

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Group Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" required>
                        @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Nature <span class="text-danger">*</span></label>
                        <select name="nature" class="form-select @error('nature') is-invalid @enderror" required>
                            <option value="">-- Select --</option>
                            <option value="new" {{ old('nature') == 'new' ? 'selected' : '' }}>New</option>
                            <option value="progressing" {{ old('nature') == 'progressing' ? 'selected' : '' }}>Progressing</option>
                            <option value="matured" {{ old('nature') == 'matured' ? 'selected' : '' }}>Matured</option>
                        </select>
                        @error('nature') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">State <span class="text-danger">*</span></label>
                        <input type="text" name="state" class="form-control @error('state') is-invalid @enderror" value="{{ old('state') }}" required>
                        @error('state') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">County <span class="text-danger">*</span></label>
                        <input type="text" name="county" class="form-control @error('county') is-invalid @enderror" value="{{ old('county') }}" required>
                        @error('county') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Payam <span class="text-danger">*</span></label>
                        <input type="text" name="payam" class="form-control @error('payam') is-invalid @enderror" value="{{ old('payam') }}" required>
                        @error('payam') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Establishing Org</label>
                        <input type="text" name="establishing_org_name" class="form-control" value="{{ old('establishing_org_name') }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Establishment Type <span class="text-danger">*</span></label>
                        <select name="establishment_type" class="form-select @error('establishment_type') is-invalid @enderror" required>
                            <option value="">-- Select --</option>
                            <option value="self" {{ old('establishment_type') == 'self' ? 'selected' : '' }}>Self</option>
                            <option value="cso" {{ old('establishment_type') == 'cso' ? 'selected' : '' }}>CSO</option>
                            <option value="ngo" {{ old('establishment_type') == 'ngo' ? 'selected' : '' }}>NGO</option>
                            <option value="government" {{ old('establishment_type') == 'government' ? 'selected' : '' }}>Government</option>
                        </select>
                        @error('establishment_type') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Formation Date <span class="text-danger">*</span></label>
                        <input type="date" name="date_formation" class="form-control @error('date_formation') is-invalid @enderror" value="{{ old('date_formation') }}" required>
                        @error('date_formation') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">VSLA Registration Date</label>
                        <input type="date" name="vsla_registration_date" class="form-control" value="{{ old('vsla_registration_date') }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Leadership <span class="text-danger">*</span></label>
                        <select name="leadership" class="form-select @error('leadership') is-invalid @enderror" required>
                            <option value="">-- Select --</option>
                            <option value="adolescent_girl" {{ old('leadership') == 'adolescent_girl' ? 'selected' : '' }}>Adolescent Girl</option>
                            <option value="woman" {{ old('leadership') == 'woman' ? 'selected' : '' }}>Woman</option>
                        </select>
                        @error('leadership') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Snapshot Month <span class="text-danger">*</span></label>
                        <input type="month" name="month" class="form-control @error('month') is-invalid @enderror" value="{{ old('month') }}" required>
                        @error('month') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>

                <div class="mt-4 text-end">
                    <a href="{{ route('component1.groups.index') }}" class="btn btn-secondary me-2">Cancel</a>
                    <button type="submit" class="btn btn-success">Save Group</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection