@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', $member->name)

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="text-success">{{ $member->name }}</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{ route('component1.members.index') }}">Members</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ route('component1.groups.show', $member->group) }}">{{ $member->group->name }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ Str::limit($member->name, 30) }}</li>
                </ol>
            </nav>
        </div>
        <div>
            <a href="{{ route('component1.members.edit', $member) }}" class="btn btn-outline-secondary me-2">
                Edit Member
            </a>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Serial No.</h6>
                    <h4 class="text-success">#{{ $member->serial_no }}</h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Gender</h6>
                    <span class="badge bg-{{ $member->gender == 'female' ? 'pink' : 'info' }} fs-5">
                        {{ ucfirst($member->gender) }}
                    </span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Age</h6>
                    <h4 class="text-dark">{{ $member->age }}</h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <h6 class="text-muted">Status</h6>
                    <span class="badge bg-{{ $member->active ? 'success' : 'secondary' }} fs-5">
                        {{ $member->active ? 'Active' : 'Inactive' }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- GBV Vulnerability Alert -->
    @if($member->is_gbv_vulnerable)
        <div class="alert alert-warning d-flex align-items-center">
            <i class="bi bi-exclamation-triangle-fill me-2"></i>
            <div>
                <strong>GBV Risk:</strong> This member is flagged as vulnerable
                @if($member->disability_status) (Disability)@endif
                @if($member->head_household) (Head of Household)@endif
                @if(in_array($member->marital_status, ['widowed', 'divorced'])) ({{ ucfirst($member->marital_status) }})@endif
            </div>
        </div>
    @endif

    <!-- Personal & Group Info -->
    <div class="row g-4 mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Personal Information</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless mb-0">
                        <tr>
                            <th width="40%">Group</th>
                            <td><a href="{{ route('component1.groups.show', $member->group) }}">{{ $member->group->name }}</a></td>
                        </tr>
                        <tr>
                            <th>Executive Committee</th>
                            <td>{{ $member->exec_committee ? 'Yes' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>Marital Status</th>
                            <td>{{ $member->marital_status ? ucwords(str_replace('_', ' ', $member->marital_status)) : '—' }}</td>
                        </tr>
                        <tr>
                            <th>Head of Household</th>
                            <td>{{ $member->head_household ? 'Yes' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>Disability</th>
                            <td>{{ $member->disability_status ? 'Yes' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>Snapshot Month</th>
                            <td>{{ \Carbon\Carbon::parse($member->month)->format('F Y') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Household Composition</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless mb-0">
                        <tr>
                            <th width="60%">Total Members</th>
                            <td><strong>{{ $member->total_household_members }}</strong></td>
                        </tr>
                        <tr>
                            <th>Female Adults</th>
                            <td>{{ $member->num_hh_female_adult }}</td>
                        </tr>
                        <tr>
                            <th>Female Adolescents</th>
                            <td>{{ $member->num_hh_female_adol }}</td>
                        </tr>
                        <tr>
                            <th>Male Adults</th>
                            <td>{{ $member->num_hh_male_adult }}</td>
                        </tr>
                        <tr>
                            <th>Male Adolescents</th>
                            <td>{{ $member->num_hh_male_adol }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Core Trainings -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Core Trainings Completed ({{ $member->core_trainings_completed_count }}/4)</h5>
            <div class="progress" style="width: 200px; height: 20px;">
                <div class="progress-bar bg-success" style="width: {{ ($member->core_trainings_completed_count / 4) * 100 }}%"></div>
            </div>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <div class="text-center p-3 rounded {{ $member->completed_core_1 ? 'bg-light-success' : 'bg-light' }} border">
                        <i class="bi bi-check-circle-fill text-success fs-3"></i>
                        <p class="mb-0 mt-2 small">Functional Literacy</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center p-3 rounded {{ $member->completed_core_2 ? 'bg-light-success' : 'bg-light' }} border">
                        <i class="bi bi-check-circle-fill text-success fs-3"></i>
                        <p class="mb-0 mt-2 small">VSLA Operations</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center p-3 rounded {{ $member->completed_core_3 ? 'bg-light-success' : 'bg-light' }} border">
                        <i class="bi bi-check-circle-fill text-success fs-3"></i>
                        <p class="mb-0 mt-2 small">Business Dev</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center p-3 rounded {{ $member->completed_core_4 ? 'bg-light-success' : 'bg-light' }} border">
                        <i class="bi bi-check-circle-fill text-success fs-3"></i>
                        <p class="mb-0 mt-2 small">Digital Literacy</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Support & Business -->
    <div class="row g-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Support Received</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless mb-0">
                        <tr>
                            <th>Specialized Training</th>
                            <td>{{ $member->received_specialized_1 ? 'Yes' : 'No' }}</td>
                        </tr>
                        @if($member->received_specialized_1)
                        <tr>
                            <td colspan="2"><small class="text-muted">{{ $member->specialized_1_details ?: '—' }}</small></td>
                        </tr>
                        @endif
                        <tr>
                            <th>In-Kind Support</th>
                            <td>{{ $member->received_in_kind ? 'Yes (' . ucfirst($member->in_kind_source) . ')' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>Productive Equipment</th>
                            <td>{{ $member->received_productive_equip ? 'Yes (' . ucfirst($member->equip_source) . ')' : 'No' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Business & Savings</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless mb-0">
                        <tr>
                            <th>Started New Business</th>
                            <td>{{ $member->started_new_business ? 'Yes' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>Actively Saving</th>
                            <td>{{ $member->actively_saving_monthly ? 'Yes' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>Total Savings</th>
                            <td><strong>SSP {{ $member->formatted_savings }}</strong></td>
                        </tr>
                        <tr>
                            <th>Outstanding Loan</th>
                            <td>SSP {{ number_format($member->outstanding_loan, 2) }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

{{-- Optional: Add Bootstrap Icons --}}
@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<style>
    .bg-light-success { background-color: rgba(40, 167, 69, 0.1) !important; }
    .border { border: 1px solid #dee2e6 !important; }
</style>
@endpush