@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', 'Component 1 – Dashboard')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <!-- Header -->
        <div class="col-12 mb-4">
            <h2 class="text-success fw-bold">Component 1</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row g-4 mb-5">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <h5 class="card-title text-muted">Registered VSLA/Community Groups</h5>
                    <h3 class="text-success fw-bold">{{ $kpiStats['groups'] }}</h3>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <h5 class="card-title text-muted">Registered Members</h5>
                    <h3 class="text-success fw-bold">{{ $kpiStats['members'] }}</h3>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <h5 class="card-title text-muted">WEOF Beneficiaries</h5>
                    <h3 class="text-success fw-bold">{{ $kpiStats['weof'] }}</h3>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <h5 class="card-title text-muted">Total Supports</h5>
                    <h3 class="text-success fw-bold">{{ $kpiStats['supports'] }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="row">
        <div class="col-12 text-end">
            <a href="{{ route('component1.groups.index') }}"
               class="btn btn-outline-success me-2">Manage Groups</a>
            <a href="{{ route('component1.members.index') }}"
               class="btn btn-outline-success me-2">Manage Members</a>
            <a href="{{ route('component1.weof.index') }}"
               class="btn btn-success">Manage WEOF Beneficiaries</a>
        </div>
    </div>
</div>
@endsection