@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
@endphp

@extends($layout)

@section('title', 'Add WEOF Beneficiary')

@section('content')
<div class="container-fluid px-4 py-3">
    <!-- Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Add New WEOF Beneficiary
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('component2.dashboard') }}">Component 1 Dashboard</a></li>
                            <li class="breadcrumb-item active">WEOF Beneficiary</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <h3 class="text-success mb-4 text-center fw-bold">
                Register New WEOF Beneficiary
                @if($selectedGroup)
                    <small class="text-muted d-block mt-1">from {{ \App\Models\C1Group::find($selectedGroup)->name }}</small>
                @endif
            </h3>

            <div class="card border-secondary border-2 shadow-lg rounded-3">
                <div class="card-body p-4 p-md-5">
                    <form action="{{ route('component2.store') }}" method="POST">
                        @csrf

                        <h5 class="mb-3 text-primary border-bottom border-secondary pb-2"><i class="fas fa-user-circle me-2"></i> 1. Basic Information</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-3">
                                <label class="form-label fw-bold">WEOF ID <span class="text-danger">*</span></label>
                                <input type="text" name="woef_id" class="form-control @error('woef_id') is-invalid @enderror"
                                       value="{{ old('woef_id') }}" required maxlength="50">
                                @error('woef_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-5">
                                <label class="form-label fw-bold">Full Name <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                       value="{{ old('name') }}" required>
                                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-2">
                                <label class="form-label fw-bold">Age <span class="text-danger">*</span></label>
                                <input type="number" name="age" class="form-control @error('age') is-invalid @enderror"
                                       value="{{ old('age') }}" min="18" max="100" required>
                                @error('age') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-2">
                                <label class="form-label fw-bold">Phone</label>
                                <input type="text" name="phone_no" class="form-control" value="{{ old('phone_no') }}" maxlength="20">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">Marital Status <span class="text-danger">*</span></label>
                                <select name="marital_status" class="form-select @error('marital_status') is-invalid @enderror" required>
                                    <option value="">-- Select --</option>
                                    <option value="married" {{ old('marital_status') == 'married' ? 'selected' : '' }}>Married</option>
                                    <option value="not_married" {{ old('marital_status') == 'not_married' ? 'selected' : '' }}>Not Married</option>
                                    <option value="divorced" {{ old('marital_status') == 'divorced' ? 'selected' : '' }}>Divorced</option>
                                    <option value="widowed" {{ old('marital_status') == 'widowed' ? 'selected' : '' }}>Widowed</option>
                                </select>
                                @error('marital_status') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Resident Status <span class="text-danger">*</span></label>
                                <select name="resident_status" class="form-select @error('resident_status') is-invalid @enderror" required>
                                    <option value="">-- Select --</option>
                                    <option value="resident" {{ old('resident_status') == 'resident' ? 'selected' : '' }}>Resident</option>
                                    <option value="returnee" {{ old('resident_status') == 'returnee' ? 'selected' : '' }}>Returnee</option>
                                    <option value="idp" {{ old('resident_status') == 'idp' ? 'selected' : '' }}>IDP</option>
                                </select>
                                @error('resident_status') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Education <span class="text-danger">*</span></label>
                                <select name="education" class="form-select @error('education') is-invalid @enderror" required>
                                    <option value="">-- Select --</option>
                                    <option value="none" {{ old('education') == 'none' ? 'selected' : '' }}>None</option>
                                    <option value="primary" {{ old('education') == 'primary' ? 'selected' : '' }}>Primary</option>
                                    <option value="secondary" {{ old('education') == 'secondary' ? 'selected' : '' }}>Secondary</option>
                                    <option value="tertiary" {{ old('education') == 'tertiary' ? 'selected' : '' }}>Tertiary</option>
                                    <option value="vocational" {{ old('education') == 'vocational' ? 'selected' : '' }}>Vocational</option>
                                </select>
                                @error('education') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label fw-bold">County <span class="text-danger">*</span></label>
                                <input type="text" name="county" class="form-control @error('county') is-invalid @enderror"
                                       value="{{ old('county') }}" required>
                                @error('county') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Payam <span class="text-danger">*</span></label>
                                <input type="text" name="payam" class="form-control @error('payam') is-invalid @enderror"
                                       value="{{ old('payam') }}" required>
                                @error('payam') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Group (Optional)</label>
                                <select name="group_id" class="form-select">
                                    <option value="">-- No Group --</option>
                                    @foreach($groups as $id => $name)
                                        <option value="{{ $id }}" {{ old('group_id', $selectedGroup) == $id ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-briefcase me-2"></i> 2. Business Details</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Business Name <span class="text-danger">*</span></label>
                                <input type="text" name="business_name" class="form-control @error('business_name') is-invalid @enderror"
                                       value="{{ old('business_name') }}" required>
                                @error('business_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Category <span class="text-danger">*</span></label>
                                <input type="text" name="business_category" class="form-control @error('business_category') is-invalid @enderror"
                                       value="{{ old('business_category') }}" required>
                                @error('business_category') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Type <span class="text-danger">*</span></label>
                                <select name="business_type" class="form-select @error('business_type') is-invalid @enderror" required>
                                    <option value="">-- Select --</option>
                                    <option value="existing" {{ old('business_type') == 'existing' ? 'selected' : '' }}>Existing</option>
                                    <option value="new" {{ old('business_type') == 'new' ? 'selected' : '' }}>New</option>
                                </select>
                                @error('business_type') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold">Establishment Year <span class="text-danger">*</span></label>
                                <input type="number" name="establishment_year" class="form-control @error('establishment_year') is-invalid @enderror"
                                       value="{{ old('establishment_year') }}" min="1900" max="{{ date('Y') }}" required>
                                @error('establishment_year') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Registered?</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="registration_status" value="1"
                                           id="reg_status" {{ old('registration_status') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="reg_status">Yes</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Target Customers <span class="text-danger">*</span></label>
                                <input type="text" name="target_customers" class="form-control @error('target_customers') is-invalid @enderror"
                                       value="{{ old('target_customers') }}" required>
                                @error('target_customers') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Monthly Revenue (SSP) <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" name="monthly_revenue" class="form-control @error('monthly_revenue') is-invalid @enderror"
                                       value="{{ old('monthly_revenue') }}" min="0" required>
                                @error('monthly_revenue') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-hand-holding-usd me-2"></i> 3. Financing Sources (select all)</h5>
                        <div class="row g-4 mb-4">
                            @foreach(['equity', 'loan', 'debt', 'grant'] as $source)
                                <div class="col-md-3">
                                    <div class="form-check pt-2">
                                        <input class="form-check-input" type="checkbox" name="financing_sources[]"
                                               value="{{ $source }}" id="fin_{{ $source }}"
                                               {{ in_array($source, old('financing_sources', [])) ? 'checked' : '' }}>
                                        <label class="form-check-label text-capitalize fw-bold" for="fin_{{ $source }}">{{ ucfirst($source) }}</label>
                                    </div>
                                </div>
                            @endforeach
                            @error('financing_sources') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-users me-2"></i> 4. Employment</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Employees Before Program</label>
                                <div class="row g-2">
                                    <div class="col-6">
                                        <input type="number" name="employees_before_male" class="form-control" placeholder="Male" min="0"
                                               value="{{ old('employees_before_male') }}" required>
                                    </div>
                                    <div class="col-6">
                                        <input type="number" name="employees_before_female" class="form-control" placeholder="Female" min="0"
                                               value="{{ old('employees_before_female') }}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Employees Now</label>
                                <div class="row g-2">
                                    <div class="col-6">
                                        <input type="number" name="employees_now_male" class="form-control" placeholder="Male" min="0"
                                               value="{{ old('employees_now_male') }}" required>
                                    </div>
                                    <div class="col-6">
                                        <input type="number" name="employees_now_female" class="form-control" placeholder="Female" min="0"
                                               value="{{ old('employees_now_female') }}" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-graduation-cap me-2"></i> 5. Training & Participation</h5>
                        <div class="row g-4 mb-4 align-items-end">
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Received Training?</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="received_training" value="1"
                                           id="received_training" {{ old('received_training') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="received_training">Yes</label>
                                </div>
                            </div>
                            <div class="col-md-6" id="training_types" style="display: {{ old('received_training') ? 'block' : 'none' }}">
                                <label class="form-label fw-bold">Training Types (select all)</label>
                                <div class="row g-2">
                                    @foreach(['functional_literacy', 'vsla_ops', 'business_dev', 'digital_literacy', 'specialized'] as $type)
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="training_type[]"
                                                       value="{{ $type }}" id="train_{{ $type }}"
                                                       {{ in_array($type, old('training_type', [])) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="train_{{ $type }}">
                                                    {{ ucwords(str_replace('_', ' ', $type)) }}
                                                </label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                @error('training_type') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold">Participation <span class="text-danger">*</span></label>
                                <select name="participation" class="form-select @error('participation') is-invalid @enderror" required>
                                    <option value="">-- Select --</option>
                                    <option value="successful" {{ old('participation') == 'successful' ? 'selected' : '' }}>Successful</option>
                                    <option value="0.5" {{ old('participation') == '0.5' ? 'selected' : '' }}>50% Alignment</option>
                                    <option value="0.8" {{ old('participation') == '0.8' ? 'selected' : '' }}>80% Alignment</option>
                                    <option value="1_completed" {{ old('participation') == '1_completed' ? 'selected' : '' }}>Fully Completed</option>
                                </select>
                                @error('participation') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-rocket me-2"></i> 6. Accelerator & Grants</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Accelerator Participation?</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="accelerator_participation" value="1"
                                           id="accel_part" {{ old('accelerator_participation') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="accel_part">Yes</label>
                                </div>
                            </div>
                            <div class="col-md-3" id="accel_grad" style="display: {{ old('accelerator_participation') ? 'block' : 'none' }}">
                                <label class="form-label fw-bold">Graduated?</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="accelerator_graduation" value="1"
                                           id="accel_graduated" {{ old('accelerator_graduation') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="accel_graduated">Yes</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">Onsite Validation?</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="onsite_validation" value="1"
                                           id="onsite" {{ old('onsite_validation') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="onsite">Yes</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">WEOF Connect?</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="participation_woef_connect" value="1"
                                           id="woef_connect" {{ old('participation_woef_connect') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="woef_connect">Yes</label>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold">1st Tranche (SSP)</label>
                                <input type="number" step="0.01" name="grant_1st_tranche" class="form-control"
                                       value="{{ old('grant_1st_tranche') }}" min="0">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold">2nd Tranche (SSP)</label>
                                <input type="number" step="0.01" name="grant_2nd_tranche" class="form-control"
                                       value="{{ old('grant_2nd_tranche') }}" min="0">
                            </div>
                        </div>

                        <div class="mt-4 pt-3 border-top border-secondary text-end">
                            <a href="{{ route('component1.weof.index') }}" class="btn btn-outline-secondary me-2"><i class="fas fa-times me-1"></i> Cancel</a>
                            <button type="submit" class="btn btn-success px-4"><i class="fas fa-save me-1"></i> Save Beneficiary</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Toggle training types
    document.getElementById('received_training').addEventListener('change', function () {
        document.getElementById('training_types').style.display = this.checked ? 'block' : 'none';
    });

    // Toggle graduation
    document.getElementById('accel_part').addEventListener('change', function () {
        document.getElementById('accel_grad').style.display = this.checked ? 'block' : 'none';
    });
</script>
@endpush
@endsection