@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', 'Add WEOF Beneficiary')

@section('content')
<div class="container-fluid py-4">
    <h3 class="text-success mb-4">
        Add New WEOF Beneficiary
        @if($selectedGroup)
            <small class="text-muted">from {{ \App\Models\C1Group::find($selectedGroup)->name }}</small>
        @endif
    </h3>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <form action="{{ route('component1.weof.store') }}" method="POST">
                @csrf

                <!-- === 1. Basic Info === -->
                <fieldset class="border p-3 rounded mb-4">
                    <legend class="w-auto float-none fs-6 text-success">1. Basic Information</legend>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">WEOF ID <span class="text-danger">*</span></label>
                            <input type="text" name="woef_id" class="form-control @error('woef_id') is-invalid @enderror"
                                   value="{{ old('woef_id') }}" required maxlength="50">
                            @error('woef_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Full Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                   value="{{ old('name') }}" required>
                            @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Age <span class="text-danger">*</span></label>
                            <input type="number" name="age" class="form-control @error('age') is-invalid @enderror"
                                   value="{{ old('age') }}" min="18" max="100" required>
                            @error('age') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Phone</label>
                            <input type="text" name="phone_no" class="form-control" value="{{ old('phone_no') }}" maxlength="20">
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Marital Status <span class="text-danger">*</span></label>
                            <select name="marital_status" class="form-select @error('marital_status') is-invalid @enderror" required>
                                <option value="">-- Select --</option>
                                <option value="married" {{ old('marital_status') == 'married' ? 'selected' : '' }}>Married</option>
                                <option value="not_married" {{ old('marital_status') == 'not_married' ? 'selected' : '' }}>Not Married</option>
                                <option value="divorced" {{ old('marital_status') == 'divorced' ? 'selected' : '' }}>Divorced</option>
                                <option value="widowed" {{ old('marital_status') == 'widowed' ? 'selected' : '' }}>Widowed</option>
                            </select>
                            @error('marital_status') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Resident Status <span class="text-danger">*</span></label>
                            <select name="resident_status" class="form-select @error('resident_status') is-invalid @enderror" required>
                                <option value="">-- Select --</option>
                                <option value="resident" {{ old('resident_status') == 'resident' ? 'selected' : '' }}>Resident</option>
                                <option value="returnee" {{ old('resident_status') == 'returnee' ? 'selected' : '' }}>Returnee</option>
                                <option value="idp" {{ old('resident_status') == 'idp' ? 'selected' : '' }}>IDP</option>
                            </select>
                            @error('resident_status') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Education <span class="text-danger">*</span></label>
                            <select name="education" class="form-select @error('education') is-invalid @enderror" required>
                                <option value="">-- Select --</option>
                                <option value="none" {{ old('education') == 'none' ? 'selected' : '' }}>None</option>
                                <option value="primary" {{ old('education') == 'primary' ? 'selected' : '' }}>Primary</option>
                                <option value="secondary" {{ old('education') == 'secondary' ? 'selected' : '' }}>Secondary</option>
                                <option value="tertiary" {{ old('education') == 'tertiary' ? 'selected' : '' }}>Tertiary</option>
                                <option value="vocational" {{ old('education') == 'vocational' ? 'selected' : '' }}>Vocational</option>
                            </select>
                            @error('education') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Group (Optional)</label>
                            <select name="group_id" class="form-select">
                                <option value="">-- No Group --</option>
                               14                                @foreach($groups as $id => $name)
                                    <option value="{{ $id }}" {{ old('group_id', $selectedGroup) == $id ? 'selected' : '' }}>
                                        {{ $name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">County <span class="text-danger">*</span></label>
                            <input type="text" name="county" class="form-control @error('county') is-invalid @enderror"
                                   value="{{ old('county') }}" required>
                            @error('county') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Payam <span class="text-danger">*</span></label>
                            <input type="text" name="payam" class="form-control @error('payam') is-invalid @enderror"
                                   value="{{ old('payam') }}" required>
                            @error('payam') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>
                </fieldset>

                <!-- === 2. Business Info === -->
                <fieldset class="border p-3 rounded mb-4">
                    <legend class="w-auto float-none fs-6 text-success">2. Business Details</legend>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Business Name <span class="text-danger">*</span></label>
                            <input type="text" name="business_name" class="form-control @error('business_name') is-invalid @enderror"
                                   value="{{ old('business_name') }}" required>
                            @error('business_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Category <span class="text-danger">*</span></label>
                            <input type="text" name="business_category" class="form-control @error('business_category') is-invalid @enderror"
                                   value="{{ old('business_category') }}" required>
                            @error('business_category') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Type <span class="text-danger">*</span></label>
                            <select name="business_type" class="form-select @error('business_type') is-invalid @enderror" required>
                                <option value="">-- Select --</option>
                                <option value="existing" {{ old('business_type') == 'existing' ? 'selected' : '' }}>Existing</option>
                                <option value="new" {{ old('business_type') == 'new' ? 'selected' : '' }}>New</option>
                            </select>
                            @error('business_type') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Establishment Year <span class="text-danger">*</span></label>
                            <input type="number" name="establishment_year" class="form-control @error('establishment_year') is-invalid @enderror"
                                   value="{{ old('establishment_year') }}" min="1900" max="{{ date('Y') }}" required>
                            @error('establishment_year') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Registered?</label>
                            <div class="form-check form-switch mt-4">
                                <input class="form-check-input" type="checkbox" name="registration_status" value="1"
                                       id="reg_status" {{ old('registration_status') ? 'checked' : '' }}>
                                <label class="form-check-label" for="reg_status">Yes</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Target Customers <span class="text-danger">*</span></label>
                            <input type="text" name="target_customers" class="form-control @error('target_customers') is-invalid @enderror"
                                   value="{{ old('target_customers') }}" required>
                            @error('target_customers') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Monthly Revenue (SSP) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" name="monthly_revenue" class="form-control @error('monthly_revenue') is-invalid @enderror"
                                   value="{{ old('monthly_revenue') }}" min="0" required>
                            @error('monthly_revenue') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>
                </fieldset>

                <!-- === 3. Financing === -->
                <fieldset class="border p-3 rounded mb-4">
                    <legend class="w-auto float-none fs-6 text-success">3. Financing Sources (select all)</legend>
                    <div class="row g-3">
                        @foreach(['equity', 'loan', 'debt', 'grant'] as $source)
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="financing_sources[]"
                                           value="{{ $source }}" id="fin_{{ $source }}"
                                           {{ in_array($source, old('financing_sources', [])) ? 'checked' : '' }}>
                                    <label class="form-check-label text-capitalize" for="fin_{{ $source }}">{{ ucfirst($source) }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    @error('financing_sources') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                </fieldset>

                <!-- === 4. Employees === -->
                <fieldset class="border p-3 rounded mb-4">
                    <legend class="w-auto float-none fs-6 text-success">4. Employment</legend>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Before Program</label>
                            <div class="row g-2">
                                <div class="col-6">
                                    <input type="number" name="employees_before_male" class="form-control" placeholder="Male" min="0"
                                           value="{{ old('employees_before_male') }}" required>
                                </div>
                                <div class="col-6">
                                    <input type="number" name="employees_before_female" class="form-control" placeholder="Female" min="0"
                                           value="{{ old('employees_before_female') }}" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Now</label>
                            <div class="row g-2">
                                <div class="col-6">
                                    <input type="number" name="employees_now_male" class="form-control" placeholder="Male" min="0"
                                           value="{{ old('employees_now_male') }}" required>
                                </div>
                                <div class="col-6">
                                    <input type="number" name="employees_now_female" class="form-control" placeholder="Female" min="0"
                                           value="{{ old('employees_now_female') }}" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>

                <!-- === 5. Training === -->
                <fieldset class="border p-3 rounded mb-4">
                    <legend class="w-auto float-none fs-6 text-success">5. Training & Participation</legend>
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Received Training?</label>
                            <div class="form-check form-switch mt-4">
                                <input class="form-check-input" type="checkbox" name="received_training" value="1"
                                       id="received_training" {{ old('received_training') ? 'checked' : '' }}>
                                <label class="form-check-label" for="received_training">Yes</label>
                            </div>
                        </div>
                        <div class="col-md-9" id="training_types" style="display: {{ old('received_training') ? 'block' : 'none' }}">
                            <label class="form-label">Training Types (select all)</label>
                            <div class="row g-2">
                                @foreach(['functional_literacy', 'vsla_ops', 'business_dev', 'digital_literacy', 'specialized'] as $type)
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="training_type[]"
                                                   value="{{ $type }}" id="train_{{ $type }}"
                                                   {{ in_array($type, old('training_type', [])) ? 'checked' : '' }}>
                                            <label class="form-check-label small" for="train_{{ $type }}">
                                                {{ ucwords(str_replace('_', ' ', $type)) }}
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            @error('training_type') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Participation <span class="text-danger">*</span></label>
                            <select name="participation" class="form-select @error('participation') is-invalid @enderror" required>
                                <option value="">-- Select --</option>
                                <option value="successful" {{ old('participation') == 'successful' ? 'selected' : '' }}>Successful</option>
                                <option value="0.5" {{ old('participation') == '0.5' ? 'selected' : '' }}>50% Alignment</option>
                                <option value="0.8" {{ old('participation') == '0.8' ? 'selected' : '' }}>80% Alignment</option>
                                <option value="1_completed" {{ old('participation') == '1_completed' ? 'selected' : '' }}>Fully Completed</option>
                            </select>
                            @error('participation') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>
                </fieldset>

                <!-- === 6. Accelerator & Grants === -->
                <fieldset class="border p-3 rounded mb-4">
                    <legend class="w-auto float-none fs-6 text-success">6. Accelerator & Grants</legend>
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Accelerator Participation?</label>
                            <div class="form-check form-switch mt-4">
                                <input class="form-check-input" type="checkbox" name="accelerator_participation" value="1"
                                       id="accel_part" {{ old('accelerator_participation') ? 'checked' : '' }}>
                                <label class="form-check-label" for="accel_part">Yes</label>
                            </div>
                        </div>
                        <div class="col-md-3" id="accel_grad" style="display: {{ old('accelerator_participation') ? 'block' : 'none' }}">
                            <label class="form-label">Graduated?</label>
                            <div class="form-check form-switch mt-4">
                                <input class="form-check-input" type="checkbox" name="accelerator_graduation" value="1"
                                       id="accel_graduated" {{ old('accelerator_graduation') ? 'checked' : '' }}>
                                <label class="form-check-label" for="accel_graduated">Yes</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Onsite Validation?</label>
                            <div class="form-check form-switch mt-4">
                                <input class="form-check-input" type="checkbox" name="onsite_validation" value="1"
                                       id="onsite" {{ old('onsite_validation') ? 'checked' : '' }}>
                                <label class="form-check-label" for="onsite">Yes</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">WEOF Connect?</label>
                            <div class="form-check form-switch mt-4">
                                <input class="form-check-input" type="checkbox" name="participation_woef_connect" value="1"
                                       id="woef_connect" {{ old('participation_woef_connect') ? 'checked' : '' }}>
                                <label class="form-check-label" for="woef_connect">Yes</label>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">1st Tranche (SSP)</label>
                            <input type="number" step="0.01" name="grant_1st_tranche" class="form-control"
                                   value="{{ old('grant_1st_tranche') }}" min="0">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">2nd Tranche (SSP)</label>
                            <input type="number" step="0.01" name="grant_2nd_tranche" class="form-control"
                                   value="{{ old('grant_2nd_tranche') }}" min="0">
                        </div>
                    </div>
                </fieldset>

                <!-- === Submit === -->
                <div class="text-end">
                    <a href="{{ route('component1.weof.index') }}" class="btn btn-secondary me- trend2">Cancel</a>
                    <button type="submit" class="btn btn-success px-4">Save Beneficiary</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Toggle training types
    document.getElementById('received_training').addEventListener('change', function () {
        document.getElementById('training_types').style.display = this.checked ? 'block' : 'none';
    });

    // Toggle graduation
    document.getElementById('accel_part').addEventListener('change', function () {
        document.getElementById('accel_grad').style.display = this.checked ? 'block' : 'none';
    });
</script>
@endpush
@endsection