@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
@endphp

@extends($layout)

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-phone-volume text-success"></i> Register New GBV Hotline Incident</h2>
    <a href="{{ route('component3.hotline.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to List
    </a>
</div>

<div class="card border-success">
    <div class="card-body">
        <form action="{{ route('component3.hotline.store') }}" method="POST">
            @csrf

            <!-- 1. Administrative Information -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-success border-bottom pb-2">1. Administrative Information</h4>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Incident ID <span class="text-danger">*</span></label>
                    <input type="text" name="incident_id" class="form-control @error('incident_id') is-invalid @enderror"
                           value="{{ old('incident_id') }}" required>
                    @error('incident_id') <div class="text-danger small">{{ $message }}</div> @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">Survivor Code <span class="text-danger">*</span></label>
                    <input type="text" name="survivor_code" class="form-control" value="{{ old('survivor_code') }}" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Case Manager Code <span class="text-danger">*</span></label>
                    <input type="text" name="case_manager_code" class="form-control" value="{{ old('case_manager_code') }}" required>
                </div>
                <div class="col-md-6 mt-3">
                    <label class="form-label">Date of Report <span class="text-danger">*</span></label>
                    <input type="date" name="date_of_report" class="form-control" value="{{ old('date_of_report', today()->format('Y-m-d')) }}" required>
                </div>
                <div class="col-md-6 mt-3">
                    <label class="form-label">Date of Incident <span class="text-danger">*</span></label>
                    <input type="date" name="date_of_incident" class="form-control" value="{{ old('date_of_incident') }}" required>
                </div>
            </div>

            <!-- 2. Survivor Information -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-success border-bottom pb-2">2. Survivor Information</h4>
                </div>
                <div class="col-md-3">
                    <label>Sex <span class="text-danger">*</span></label>
                    <select name="sex" class="form-select" required>
                        <option value="">-- Select --</option>
                        <option value="F" {{ old('sex') == 'F' ? 'selected' : '' }}>Female</option>
                        <option value="M" {{ old('sex') == 'M' ? 'selected' : '' }}>Male</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label>Date of Birth</label>
                    <input type="date" name="date_of_birth" class="form-control" value="{{ old('date_of_birth') }}">
                </div>
                <div class="col-md-3">
                    <label>Person with Disability?</label><br>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="person_with_disability" value="1" {{ old('person_with_disability') ? 'checked' : '' }}>
                        <label class="form-check-label">Yes</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="person_with_disability" value="0" {{ old('person_with_disability') == '0' ? 'checked' : '' }}>
                        <label class="form-check-label">No</label>
                    </div>
                </div>
                <div class="col-md-3">
                    <label>Unaccompanied/Separated Child?</label><br>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="unaccompanied_or_separated_child" value="1">
                        <label class="form-check-label">Yes</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="unaccompanied_or_separated_child" value="0" checked>
                        <label class="form-check-label">No</label>
                    </div>
                </div>
            </div>

            <!-- 3. GBV Type & Consent -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-success border-bottom pb-2">3. Incident & Consent</h4>
                </div>
                <div class="col-md-6">
                    <label>GBV Type <span class="text-danger">*</span></label>
                    <select name="gbv_type" class="form-select" required>
                        <option value="">-- Select Type --</option>
                        <option>Rape</option>
                        <option>Sexual Assault</option>
                        <option>Physical Assault</option>
                        <option>Forced Marriage</option>
                        <option>Denial of Resources</option>
                        <option>Psychological/Emotional Abuse</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label text-danger fw-bold">
                        Consent for Information Sharing <span class="text-danger">*</span>
                    </label><br>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="consent_given_for_information_sharing" value="1" required>
                        <label class="form-check-label text-success fw-bold">YES - Consent Given</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="consent_given_for_information_sharing" value="0">
                        <label class="form-check-label text-danger fw-bold">NO - Consent NOT Given</label>
                    </div>
                </div>
            </div>

            <div class="text-center mt-4">
                <button type="submit" class="btn btn-sswseep text-white btn-lg px-5">
                    <i class="fas fa-save"></i> Save Hotline Incident
                </button>
            </div>
        </form>
    </div>
</div>
@endsection