@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
@endphp

@extends($layout)

@section('title', 'Component 3 - Prevention Sessions Register')

@section('content')
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 col-lg-2 d-md-block bg-success sidebar collapse" id="sidebarMenu">
            <div class="position-sticky pt-3">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link text-white {{ request()->routeIs('component3.prevention.index') ? 'active bg-white text-success' : '' }}"
                           href="{{ route('component3.prevention.index') }}">
                            <i class="bi bi-journal-text me-2"></i> Prevention Register
                        </a>
                    </li>
                    <!-- Add more Component 3 menu items here as you build them -->
                </ul>
            </div>
        </div>

        <!-- Main Content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-4 border-bottom">
                <h1 class="h2 text-success">Prevention Sessions Register</h1>
                <a href="{{ route('component3.prevention.create') }}" class="btn btn-success btn-lg">
                    <i class="bi bi-plus-circle me-2"></i> Record New Session
                </a>
            </div>

            <!-- Success Message -->
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <!-- Quick Stats Cards -->
            <div class="row mb-4">
                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Total Sessions
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        {{ $registers->total() }}
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-calendar-event fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Sessions This Month
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        {{ $registers->where('session_date', '>=', now()->startOfMonth())->count() }}
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-calendar-check fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Add more quick stats as needed -->
            </div>

            <!-- Data Table -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 bg-success text-white">
                    <h6 class="m-0 font-weight-bold">Registered Prevention Sessions</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="dataTable" width="100%" cellspacing="0">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Session Date</th>
                                    <th>Topic / Theme</th>
                                    <th>Facilitator</th>
                                    <th>Location (County/Payam)</th>
                                    <th>Male Participants</th>
                                    <th>Female Participants</th>
                                    <th>Total Participants</th>
                                    <th>Created By</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($registers as $register)
                                    <tr>
                                        <td>{{ $loop->iteration + ($registers->currentPage() - 1) * $registers->perPage() }}</td>
                                        <td>{{ $register->session_date->format('d M Y') }}</td>
                                        <td>{{ $register->topic ?? '—' }}</td>
                                        <td>{{ $register->facilitator_name ?? '—' }}</td>
                                        <td>{{ $register->county }} / {{ $register->payam }}</td>
                                        <td>{{ $register->male_participants }}</td>
                                        <td>{{ $register->female_participants }}</td>
                                        <td>{{ $register->male_participants + $register->female_participants }}</td>
                                        <td>{{ $register->creator?->name ?? 'System' }}</td>
                                        <td>
                                            <a href="{{ route('component3.prevention.show', $register) }}"
                                               class="btn btn-sm btn-info text-white" title="View">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="{{ route('component3.prevention.edit', $register) }}"
                                               class="btn btn-sm btn-warning text-white" title="Edit">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="{{ route('component3.prevention.destroy', $register) }}"
                                                  method="POST" class="d-inline"
                                                  onsubmit="return confirm('Delete this session permanently?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center py-4 text-muted">
                                            No prevention sessions recorded yet.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $registers->links() }}
                    </div>
                </div>
            </div>

            <!-- Reports Button -->
            <div class="text-end mt-4">
                <a href="{{ route('component3.prevention.reports') }}" class="btn btn-success btn-lg">
                    <i class="bi bi-file-earmark-bar-graph me-2"></i> View Reports & Charts
                </a>
            </div>
        </main>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
<link href="{{ asset('vendor/datatables/dataTables.bootstrap5.min.css') }}" rel="stylesheet">
@endpush

@push('scripts')
<script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('vendor/datatables/dataTables.bootstrap5.min.js') }}"></script>
<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            pageLength: 25,
            responsive: true,
            order: [[1, 'desc']], // newest session first
            columnDefs: [
                { orderable: false, targets: 9 } // disable sorting on Actions column
            ]
        });
    });
</script>
@endpush