
<?php $__env->startSection('title', 'Create User'); ?>
<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-success text-white">
                    <h4 class="mb-0">Create New User</h4>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('admin.users.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Password</label>
                            <input type="password" name="password" class="form-control" required minlength="8">
                        </div>
                        <div class="mb-3">
                            <label>Confirm Password</label>
                            <input type="password" name="password_confirmation" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Role</label>
                            <select name="role" class="form-control" required>
                                <option value="super_admin">Super Admin</option>
                                <option value="component_1_user">Component 1 User</option>
                                <option value="component_2_user">Component 2 User</option>
                                <option value="component_3_user">Component 3 User</option>
                                <option value="component_4_user">Component 4 User</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label>Assigned Component (optional)</label>
                            <select name="component_id" class="form-control">
                                <option value="">All Components (Super Admin)</option>
                                <option value="1">Component 1 Only</option>
                                <option value="2">Component 2 Only</option>
                                <option value="3">Component 3 Only</option>
                                <option value="4">Component 4 Only</option>
                            </select>
                        </div>
                        <div class="text-end">
                            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-success">Create User</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/admin/users/create.blade.php ENDPATH**/ ?>